/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.object;

import org.eclipse.actf.model.dom.dombycom.INodeExVideo;
import org.eclipse.actf.model.dom.dombycom.impl.NodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.object.MediaObjectImpl;
import org.eclipse.actf.util.win32.comclutch.DispatchException;
import org.eclipse.actf.util.win32.comclutch.IDispatch;

class RPNodeImpl
extends MediaObjectImpl {
    private boolean pause = false;
    private boolean play = false;
    private boolean stop = false;
    private boolean mute = false;

    RPNodeImpl(NodeImpl nodeImpl, IDispatch iDispatch) {
        super(nodeImpl, iDispatch);
    }

    private Object exec0(String string) {
        try {
            return this.inode.invoke0(string);
        }
        catch (DispatchException dispatchException) {
            return null;
        }
    }

    private Object exec1(String string, Object object) {
        try {
            return this.inode.invoke1(string, object);
        }
        catch (DispatchException dispatchException) {
            return null;
        }
    }

    public boolean getMuteState() {
        Object object = this.exec0("GetMute");
        if (this.mute) {
            this.mute = false;
            return true;
        }
        if (object != null) {
            return (Boolean)object;
        }
        return false;
    }

    public int getVolume() {
        Object object = this.exec0("GetVolume");
        if (object != null) {
            return ((Short)object).intValue() * 1000 / 100;
        }
        return 0;
    }

    public boolean muteMedia(boolean bl) {
        this.exec1("SetMute", bl ? 1 : 0);
        this.mute = true;
        return true;
    }

    public boolean setVolume(int n) {
        int n2 = n * 100 / 1000;
        this.exec1("SetVolume", n2);
        return true;
    }

    public boolean fastForward() {
        return false;
    }

    public boolean fastReverse() {
        this.exec0("Rewind");
        return true;
    }

    public double getCurrentPosition() {
        Object object = this.exec0("GetPosition");
        if (object != null) {
            return ((Integer)object).doubleValue() / 1000.0;
        }
        return 0.0;
    }

    public INodeExVideo.VideoState getCurrentState() {
        Object object = this.exec0("GetPlayState");
        if (this.pause) {
            this.stop = false;
            this.play = false;
            this.pause = false;
            return INodeExVideo.VideoState.STATE_PAUSE;
        }
        if (this.play) {
            this.stop = false;
            this.play = false;
            this.pause = false;
            return INodeExVideo.VideoState.STATE_PLAY;
        }
        if (this.stop) {
            this.stop = false;
            this.play = false;
            this.pause = false;
            return INodeExVideo.VideoState.STATE_STOP;
        }
        if (object != null) {
            switch ((Integer)object) {
                case 0: {
                    return INodeExVideo.VideoState.STATE_STOP;
                }
                case 1: 
                case 2: {
                    return INodeExVideo.VideoState.STATE_WAITING;
                }
                case 3: {
                    return INodeExVideo.VideoState.STATE_PLAY;
                }
                case 4: {
                    return INodeExVideo.VideoState.STATE_PAUSE;
                }
                case 5: {
                    return INodeExVideo.VideoState.STATE_WAITING;
                }
            }
        }
        return INodeExVideo.VideoState.STATE_UNKNOWN;
    }

    public double getTotalLength() {
        return 0.0;
    }

    public boolean nextTrack() {
        return false;
    }

    public boolean pauseMedia() {
        if (this.getCurrentState() == INodeExVideo.VideoState.STATE_PAUSE) {
            return this.playMedia();
        }
        this.exec0("DoPause");
        this.pause = true;
        return true;
    }

    public boolean playMedia() {
        this.exec0("DoPlay");
        this.play = true;
        return true;
    }

    public boolean previousTrack() {
        return false;
    }

    public boolean stopMedia() {
        this.exec0("DoStop");
        this.stop = true;
        return true;
    }
}

