/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.eval;

import com.ibm.icu.text.MessageFormat;
import java.util.TreeSet;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.visualization.eval.IEvaluationItem;
import org.eclipse.actf.visualization.eval.IGuidelineItem;
import org.eclipse.actf.visualization.eval.ITechniquesItem;
import org.eclipse.actf.visualization.eval.guideline.GuidelineSelectionChangedEvent;
import org.eclipse.actf.visualization.eval.problem.IProblemConst;
import org.eclipse.actf.visualization.internal.eval.EvaluationPlugin;
import org.eclipse.actf.visualization.internal.eval.GuidelineItemImpl;
import org.eclipse.actf.visualization.internal.eval.guideline.GuidelineItemDescription;
import org.eclipse.actf.visualization.internal.eval.guideline.MetricsItem;
import org.eclipse.swt.graphics.Image;

public class EvaluationItemImpl
implements IEvaluationItem {
    private static final String LISTENABILITY = "listenability";
    private static final String NAVIGABILITY = "navigability";
    private static final String COMPLIANCE = "compliance";
    private static final String PERCEIVABLE = "perceivable";
    private static final String OPERABLE = "operable";
    private static final String UNDERSTANDABLE = "understandable";
    private static final String ROBUST = "robust";
    private static final Image ERROR_C_IMAGE = EvaluationPlugin.getImageDescriptor("icons/ErrC.png").createImage();
    private static final Image ERROR_N_IMAGE = EvaluationPlugin.getImageDescriptor("icons/ErrN.png").createImage();
    private static final Image ERROR_L_IMAGE = EvaluationPlugin.getImageDescriptor("icons/ErrL.png").createImage();
    private static final Image ERROR_O_IMAGE = EvaluationPlugin.getImageDescriptor("icons/ErrO.png").createImage();
    private static final Image ERROR_P_IMAGE = EvaluationPlugin.getImageDescriptor("icons/ErrP.png").createImage();
    private static final Image ERROR_R_IMAGE = EvaluationPlugin.getImageDescriptor("icons/ErrR.png").createImage();
    private static final Image ERROR_U_IMAGE = EvaluationPlugin.getImageDescriptor("icons/ErrU.png").createImage();
    private static final Image ERROR_IMAGE = EvaluationPlugin.getImageDescriptor("icons/Err.png").createImage();
    private static final Image WARN_C_IMAGE = EvaluationPlugin.getImageDescriptor("icons/WarnC.png").createImage();
    private static final Image WARN_N_IMAGE = EvaluationPlugin.getImageDescriptor("icons/WarnN.png").createImage();
    private static final Image WARN_L_IMAGE = EvaluationPlugin.getImageDescriptor("icons/WarnL.png").createImage();
    private static final Image WARN_O_IMAGE = EvaluationPlugin.getImageDescriptor("icons/WarnO.png").createImage();
    private static final Image WARN_P_IMAGE = EvaluationPlugin.getImageDescriptor("icons/WarnP.png").createImage();
    private static final Image WARN_R_IMAGE = EvaluationPlugin.getImageDescriptor("icons/WarnR.png").createImage();
    private static final Image WARN_U_IMAGE = EvaluationPlugin.getImageDescriptor("icons/WarnU.png").createImage();
    private static final Image WARN_IMAGE = EvaluationPlugin.getImageDescriptor("icons/Warn.png").createImage();
    private static final Image USER_C_IMAGE = EvaluationPlugin.getImageDescriptor("icons/ConfC.png").createImage();
    private static final Image USER_N_IMAGE = EvaluationPlugin.getImageDescriptor("icons/ConfN.png").createImage();
    private static final Image USER_L_IMAGE = EvaluationPlugin.getImageDescriptor("icons/ConfL.png").createImage();
    private static final Image USER_O_IMAGE = EvaluationPlugin.getImageDescriptor("icons/ConfO.png").createImage();
    private static final Image USER_P_IMAGE = EvaluationPlugin.getImageDescriptor("icons/ConfP.png").createImage();
    private static final Image USER_R_IMAGE = EvaluationPlugin.getImageDescriptor("icons/ConfR.png").createImage();
    private static final Image USER_U_IMAGE = EvaluationPlugin.getImageDescriptor("icons/ConfU.png").createImage();
    private static final Image USER_IMAGE = EvaluationPlugin.getImageDescriptor("icons/Conf.png").createImage();
    private static final Image INFO_C_IMAGE = EvaluationPlugin.getImageDescriptor("icons/InfoC.png").createImage();
    private static final Image INFO_N_IMAGE = EvaluationPlugin.getImageDescriptor("icons/InfoN.png").createImage();
    private static final Image INFO_L_IMAGE = EvaluationPlugin.getImageDescriptor("icons/InfoL.png").createImage();
    private static final Image INFO_O_IMAGE = EvaluationPlugin.getImageDescriptor("icons/InfoO.png").createImage();
    private static final Image INFO_P_IMAGE = EvaluationPlugin.getImageDescriptor("icons/InfoP.png").createImage();
    private static final Image INFO_R_IMAGE = EvaluationPlugin.getImageDescriptor("icons/InfoR.png").createImage();
    private static final Image INFO_U_IMAGE = EvaluationPlugin.getImageDescriptor("icons/InfoU.png").createImage();
    private static final Image INFO_IMAGE = EvaluationPlugin.getImageDescriptor("icons/Info.png").createImage();
    private String id = "";
    private IGuidelineItem[] guidelines = new GuidelineItemImpl[0];
    private ITechniquesItem[][] techniques = new ITechniquesItem[0][];
    private MetricsItem[] metrics = new MetricsItem[0];
    private String description;
    private String[] tableDataMetrics = new String[0];
    private String[] tableDataGuideline = new String[0];
    private String tableDataTechniques = "";
    private Image[] metricsIcons = new Image[0];
    private int[] metricsScores = new int[0];
    private short severity = (short)8;
    private String severityStr = "info";

    public EvaluationItemImpl(String string, String string2) {
        this.id = string;
        this.setSeverity(string2);
        this.description = GuidelineItemDescription.getDescription(string);
    }

    public String createDescription(String string) {
        return MessageFormat.format((String)this.description, (Object[])new Object[]{string});
    }

    public String createDescription() {
        return this.description;
    }

    public IGuidelineItem[] getGuidelines() {
        return this.guidelines;
    }

    public void setGuidelines(IGuidelineItem[] iGuidelineItemArray) {
        this.guidelines = iGuidelineItemArray;
    }

    public void setTechniques(ITechniquesItem[][] iTechniquesItemArray) {
        Object object;
        this.techniques = iTechniquesItemArray;
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = 0;
        while (n < iTechniquesItemArray.length) {
            object = iTechniquesItemArray[n];
            ITechniquesItem[] iTechniquesItemArray2 = object;
            int n2 = ((ITechniquesItem[])object).length;
            int n3 = 0;
            while (n3 < n2) {
                ITechniquesItem iTechniquesItem = iTechniquesItemArray2[n3];
                treeSet.add(iTechniquesItem.getId());
                ++n3;
            }
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        object = treeSet.iterator();
        if (object.hasNext()) {
            stringBuffer.append((String)object.next());
        }
        while (object.hasNext()) {
            stringBuffer.append(", " + (String)object.next());
        }
        this.tableDataTechniques = stringBuffer.toString();
    }

    public String getId() {
        return this.id;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getSeverityStr() {
        return this.severityStr;
    }

    private void setSeverity(String string) {
        this.severity = (short)8;
        this.severityStr = IProblemConst.INFO;
        if (string != null) {
            if ("error".equalsIgnoreCase(string = string.trim())) {
                this.severity = 1;
                this.severityStr = IProblemConst.ESSENTIAL;
            } else if ("warning".equalsIgnoreCase(string)) {
                this.severity = (short)2;
                this.severityStr = IProblemConst.WARNING;
            } else if ("user".equalsIgnoreCase(string)) {
                this.severity = (short)4;
                this.severityStr = IProblemConst.USER_CHECK;
            }
        }
    }

    public MetricsItem[] getMetricsItems() {
        return this.metrics;
    }

    public void setMetrics(MetricsItem[] metricsItemArray) {
        this.metrics = metricsItemArray;
    }

    public void initMetrics(String[] stringArray) {
        this.tableDataMetrics = new String[stringArray.length];
        this.metricsScores = new int[stringArray.length];
        this.metricsIcons = new Image[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            this.tableDataMetrics[n] = "";
            this.metricsScores[n] = 0;
            this.metricsIcons[n] = null;
            int n2 = 0;
            while (n2 < this.metrics.length) {
                MetricsItem metricsItem = this.metrics[n2];
                if (string.equalsIgnoreCase(metricsItem.getMetricsName())) {
                    this.metricsScores[n] = metricsItem.getScore();
                    if (metricsItem.getScore() != 0) {
                        this.tableDataMetrics[n] = String.valueOf(Integer.toString(-metricsItem.getScore())) + " ";
                    }
                    switch (this.severity) {
                        case 1: {
                            this.metricsIcons[n] = string.equalsIgnoreCase(PERCEIVABLE) ? ERROR_P_IMAGE : (string.equalsIgnoreCase(OPERABLE) ? ERROR_O_IMAGE : (string.equalsIgnoreCase(UNDERSTANDABLE) ? ERROR_U_IMAGE : (string.equalsIgnoreCase(ROBUST) ? ERROR_R_IMAGE : (string.equalsIgnoreCase(COMPLIANCE) ? ERROR_C_IMAGE : (string.equalsIgnoreCase(NAVIGABILITY) ? ERROR_N_IMAGE : (string.equalsIgnoreCase(LISTENABILITY) ? ERROR_L_IMAGE : ERROR_IMAGE))))));
                            this.tableDataMetrics[n] = String.valueOf(this.tableDataMetrics[n]) + "(" + IProblemConst.ESSENTIAL + ")";
                            break;
                        }
                        case 2: {
                            this.metricsIcons[n] = string.equalsIgnoreCase(PERCEIVABLE) ? WARN_P_IMAGE : (string.equalsIgnoreCase(OPERABLE) ? WARN_O_IMAGE : (string.equalsIgnoreCase(UNDERSTANDABLE) ? WARN_U_IMAGE : (string.equalsIgnoreCase(ROBUST) ? WARN_R_IMAGE : (string.equalsIgnoreCase(COMPLIANCE) ? WARN_C_IMAGE : (string.equalsIgnoreCase(NAVIGABILITY) ? WARN_N_IMAGE : (string.equalsIgnoreCase(LISTENABILITY) ? WARN_L_IMAGE : WARN_IMAGE))))));
                            this.tableDataMetrics[n] = String.valueOf(this.tableDataMetrics[n]) + "(" + IProblemConst.USER_CHECK + ")";
                            break;
                        }
                        case 4: {
                            this.metricsIcons[n] = string.equalsIgnoreCase(PERCEIVABLE) ? USER_P_IMAGE : (string.equalsIgnoreCase(OPERABLE) ? USER_O_IMAGE : (string.equalsIgnoreCase(UNDERSTANDABLE) ? USER_U_IMAGE : (string.equalsIgnoreCase(ROBUST) ? USER_R_IMAGE : (string.equalsIgnoreCase(COMPLIANCE) ? USER_C_IMAGE : (string.equalsIgnoreCase(NAVIGABILITY) ? USER_N_IMAGE : (string.equalsIgnoreCase(LISTENABILITY) ? USER_L_IMAGE : USER_IMAGE))))));
                            this.tableDataMetrics[n] = String.valueOf(this.tableDataMetrics[n]) + "(" + IProblemConst.USER_CHECK + ")";
                            break;
                        }
                        case 8: {
                            this.metricsIcons[n] = string.equalsIgnoreCase(PERCEIVABLE) ? INFO_P_IMAGE : (string.equalsIgnoreCase(OPERABLE) ? INFO_O_IMAGE : (string.equalsIgnoreCase(UNDERSTANDABLE) ? INFO_U_IMAGE : (string.equalsIgnoreCase(ROBUST) ? INFO_R_IMAGE : (string.equalsIgnoreCase(COMPLIANCE) ? INFO_C_IMAGE : (string.equalsIgnoreCase(NAVIGABILITY) ? INFO_N_IMAGE : (string.equalsIgnoreCase(LISTENABILITY) ? INFO_L_IMAGE : INFO_IMAGE))))));
                            this.tableDataMetrics[n] = String.valueOf(this.tableDataMetrics[n]) + "(" + IProblemConst.INFO + ")";
                        }
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.id) + " " + this.severity + " : " + FileUtils.LINE_SEP);
        int n = 0;
        while (n < this.guidelines.length) {
            stringBuffer.append("  " + this.guidelines[n] + FileUtils.LINE_SEP);
            ++n;
        }
        n = 0;
        while (n < this.tableDataGuideline.length) {
            stringBuffer.append("  " + this.tableDataGuideline[n] + FileUtils.LINE_SEP);
            ++n;
        }
        n = 0;
        while (n < this.metrics.length) {
            stringBuffer.append("  " + this.metrics[n] + FileUtils.LINE_SEP);
            ++n;
        }
        n = 0;
        while (n < this.tableDataMetrics.length) {
            stringBuffer.append("  " + this.tableDataMetrics[n] + FileUtils.LINE_SEP);
            ++n;
        }
        return stringBuffer.toString();
    }

    private void updateTableDataGuidelines(String[] stringArray) {
        this.tableDataGuideline = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.guidelines.length) {
                IGuidelineItem iGuidelineItem = this.guidelines[n2];
                if (iGuidelineItem.isEnabled() && stringArray[n].equalsIgnoreCase(iGuidelineItem.getGuidelineName())) {
                    if (bl) {
                        stringBuffer.append(", ");
                    } else {
                        bl = true;
                    }
                    if (iGuidelineItem.getLevel().length() > 0) {
                        stringBuffer.append(String.valueOf(iGuidelineItem.getLevel()) + ": " + iGuidelineItem.getId());
                    } else {
                        stringBuffer.append(iGuidelineItem.getId());
                    }
                }
                ++n2;
            }
            this.tableDataGuideline[n] = stringBuffer.toString();
            ++n;
        }
    }

    private void updateTableDataTechniques() {
        ITechniquesItem[] iTechniquesItemArray;
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = 0;
        while (n < this.guidelines.length) {
            if (this.guidelines[n].isEnabled()) {
                ITechniquesItem[] iTechniquesItemArray2 = iTechniquesItemArray = this.techniques[n];
                int n2 = iTechniquesItemArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    ITechniquesItem iTechniquesItem = iTechniquesItemArray2[n3];
                    treeSet.add(iTechniquesItem.getId());
                    ++n3;
                }
            }
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        iTechniquesItemArray = treeSet.iterator();
        if (iTechniquesItemArray.hasNext()) {
            stringBuffer.append((String)iTechniquesItemArray.next());
        }
        while (iTechniquesItemArray.hasNext()) {
            stringBuffer.append(", " + (String)iTechniquesItemArray.next());
        }
        this.tableDataTechniques = stringBuffer.toString();
    }

    public int[] getMetricsScores() {
        return this.metricsScores;
    }

    public String[] getTableDataGuideline() {
        return this.tableDataGuideline;
    }

    public String[] getTableDataMetrics() {
        return this.tableDataMetrics;
    }

    public Image[] getMetricsIcons() {
        return this.metricsIcons;
    }

    public ITechniquesItem[][] getTechniques() {
        return this.techniques;
    }

    public String getTableDataTechniques() {
        return this.tableDataTechniques;
    }

    public void selectionChanged(GuidelineSelectionChangedEvent guidelineSelectionChangedEvent) {
        this.updateTableDataTechniques();
        this.updateTableDataGuidelines(guidelineSelectionChangedEvent.getGuidelineHolder().getGuidelineNames());
    }
}

