/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.ui.report.table;

import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.ui.report.table.ResultTableSorterBase;
import org.eclipse.jface.viewers.Viewer;

public class ResultTableSorter
extends ResultTableSorterBase {
    private GuidelineHolder guidelineHolder = GuidelineHolder.getInstance();
    private boolean inverse = false;
    private int curColumn = -1;
    private int metricsFinPos = this.guidelineHolder.getMetricsNames().length + 1;
    private int guidelineFinPos = this.metricsFinPos + this.guidelineHolder.getGuidelineData().length;

    protected int compareTotalScore(IProblemItem iProblemItem, IProblemItem iProblemItem2) {
        int[] nArray = iProblemItem.getMetricsScores();
        int[] nArray2 = iProblemItem2.getMetricsScores();
        int n = 0;
        boolean[] blArray = this.guidelineHolder.getMatchedMetrics();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (blArray[n2]) {
                n += nArray2[n2] - nArray[n2];
            }
            ++n2;
        }
        return n;
    }

    protected int compareHighlight(IProblemItem iProblemItem, IProblemItem iProblemItem2) {
        boolean bl;
        boolean bl2 = iProblemItem.isCanHighlight();
        if (bl2 == (bl = iProblemItem2.isCanHighlight())) {
            return this.compareTotalScore(iProblemItem, iProblemItem2);
        }
        if (bl2) {
            return -1;
        }
        return 1;
    }

    public int compare(Viewer viewer, Object object, Object object2) {
        int n = 0;
        if (object != null && object2 != null) {
            try {
                IProblemItem iProblemItem = (IProblemItem)object;
                IProblemItem iProblemItem2 = (IProblemItem)object2;
                n = this.curColumn == -1 ? this.compareTotalScore(iProblemItem, iProblemItem2) : (this.curColumn == 0 ? this.compareHighlight(iProblemItem, iProblemItem2) : (this.curColumn < this.metricsFinPos ? this.compareScore(iProblemItem, iProblemItem2, this.curColumn - 1) : (this.curColumn < this.guidelineFinPos ? this.compareGuideline(iProblemItem, iProblemItem2, this.curColumn - this.metricsFinPos) : (this.curColumn == this.guidelineFinPos ? this.compareLine(iProblemItem, iProblemItem2) : this.compareString(iProblemItem.getDescription(), iProblemItem2.getDescription())))));
                if (n == 0 && (n = this.compareSeverity(iProblemItem, iProblemItem2)) == 0) {
                    n = iProblemItem.getSerialNumber() - iProblemItem2.getSerialNumber();
                }
                if (this.inverse) {
                    return -n;
                }
                return n;
            }
            catch (Exception exception) {}
        }
        return super.compare(viewer, object, object2);
    }

    public void setCurColumn(int n) {
        if (this.curColumn == n) {
            this.inverse = !this.inverse;
        } else {
            this.inverse = false;
            this.curColumn = n;
        }
    }

    public void reset() {
        this.curColumn = -1;
        this.inverse = false;
    }
}

