/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.profile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.dialogs.JdbcDriverManagerDialog;
import org.eclipse.birt.report.data.oda.jdbc.ui.profile.JDBCPropertyPage;
import org.eclipse.birt.report.data.oda.jdbc.ui.profile.JDBCSelectionWizardPage;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.DriverLoader;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ExceptionHandler;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.JDBCDriverInformation;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.JdbcToolKit;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Utility;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.bidi.profile.BidiSettingsSupport;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JDBCSelectionPageHelper {
    private WizardPage m_wizardPage;
    private PreferencePage m_propertyPage;
    private BidiSettingsSupport bidiSupportObj;
    private static final String EMPTY_STRING = "";
    private ComboViewer driverChooserCombo;
    private Text jdbcUrl;
    private Text userName;
    private Text password;
    private Text jndiName;
    private Button manageButton;
    private Button testButton;
    private String DEFAULT_MESSAGE;
    private static final String EMPTY_URL = JdbcPlugin.getResourceString("error.emptyDatabaseUrl");
    private final String JDBC_EXTENSION_ID = "org.eclipse.birt.report.data.oda.jdbc";

    JDBCSelectionPageHelper(WizardPage page) {
        this.DEFAULT_MESSAGE = JdbcPlugin.getResourceString("wizard.message.createDataSource");
        this.m_wizardPage = page;
        if (page instanceof JDBCSelectionWizardPage) {
            this.bidiSupportObj = ((JDBCSelectionWizardPage)page).getBidiSupport();
        }
    }

    JDBCSelectionPageHelper(PreferencePage page) {
        this.DEFAULT_MESSAGE = JdbcPlugin.getResourceString("wizard.message.editDataSource");
        this.m_propertyPage = page;
        if (page instanceof JDBCPropertyPage) {
            this.bidiSupportObj = ((JDBCPropertyPage)page).getBidiSupport();
        }
    }

    Composite createCustomControl(Composite parent) {
        ScrolledComposite scrollContent = new ScrolledComposite(parent, 768);
        scrollContent.setAlwaysShowScrollBars(false);
        scrollContent.setExpandHorizontal(true);
        scrollContent.setLayout((Layout)new FillLayout());
        Composite content = new Composite((Composite)scrollContent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.verticalSpacing = 10;
        layout.marginBottom = 10;
        content.setLayout((Layout)layout);
        new Label(content, 131072).setText(JdbcPlugin.getResourceString("wizard.label.driverClass"));
        this.driverChooserCombo = new ComboViewer(content, 4);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        this.driverChooserCombo.getControl().setLayoutData((Object)gridData);
        List driverList = JdbcToolKit.getJdbcDriversFromODADir("org.eclipse.birt.report.data.oda.jdbc");
        this.driverChooserCombo.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement != null) {
                    return ((ArrayList)inputElement).toArray();
                }
                return new JDBCDriverInformation[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.driverChooserCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object inputElement) {
                JDBCDriverInformation info = (JDBCDriverInformation)inputElement;
                return info.getDisplayString();
            }
        });
        this.driverChooserCombo.setInput((Object)this.sortDriverList(driverList));
        this.driverChooserCombo.addSelectionChangedListener(new ISelectionChangedListener(){
            private String driverClassName;

            public void selectionChanged(SelectionChangedEvent event) {
                String className;
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                JDBCDriverInformation info = (JDBCDriverInformation)selection.getFirstElement();
                String string = className = info != null ? info.getDriverClassName() : JDBCSelectionPageHelper.EMPTY_STRING;
                if (className.equalsIgnoreCase(this.driverClassName)) {
                    return;
                }
                this.driverClassName = className;
                if (info != null) {
                    if (info.getUrlFormat() != null) {
                        JDBCSelectionPageHelper.this.jdbcUrl.setText(info.getUrlFormat());
                    } else {
                        JDBCSelectionPageHelper.this.jdbcUrl.setText(JDBCSelectionPageHelper.EMPTY_STRING);
                    }
                }
                JDBCSelectionPageHelper.this.jndiName.setText(JDBCSelectionPageHelper.EMPTY_STRING);
                JDBCSelectionPageHelper.this.userName.setText(JDBCSelectionPageHelper.EMPTY_STRING);
                JDBCSelectionPageHelper.this.password.setText(JDBCSelectionPageHelper.EMPTY_STRING);
                JDBCSelectionPageHelper.this.updateTestButton();
            }
        });
        new Label(content, 131072).setText(JdbcPlugin.getResourceString("wizard.label.url"));
        this.jdbcUrl = new Text(content, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.jdbcUrl.setLayoutData((Object)gridData);
        new Label(content, 131072).setText(JdbcPlugin.getResourceString("wizard.label.username"));
        this.userName = new Text(content, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        this.userName.setLayoutData((Object)gridData);
        new Label(content, 131072).setText(JdbcPlugin.getResourceString("wizard.label.password"));
        this.password = new Text(content, 0x400800);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        this.password.setLayoutData((Object)gridData);
        String jndiLabel = JdbcPlugin.getResourceString("wizard.label.jndiname");
        new Label(content, 131072).setText(jndiLabel);
        this.jndiName = new Text(content, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        this.jndiName.setLayoutData((Object)gridData);
        new Label(content, 0);
        this.manageButton = new Button(content, 8);
        this.manageButton.setText(JdbcPlugin.getResourceString("wizard.label.manageDriver"));
        this.testButton = new Button(content, 8);
        this.testButton.setText(JdbcPlugin.getResourceString("wizard.label.testConnection"));
        this.testButton.setLayoutData((Object)new GridData(2));
        Point size = content.computeSize(-1, -1);
        content.setSize(size.x, size.y);
        scrollContent.setMinWidth(size.x + 10);
        scrollContent.setContent((Control)content);
        this.addControlListeners();
        this.updateTestButton();
        this.verifyJDBCProperties();
        Utility.setSystemHelp(this.getControl(), "org.eclipse.birt.cshelp.Wizard_JDBC_Datasource_ID");
        return content;
    }

    void initCustomControl(Properties profileProps) {
        if (profileProps == null || profileProps.isEmpty()) {
            return;
        }
        String driverClass = profileProps.getProperty("odaDriverClass");
        if (driverClass == null) {
            driverClass = EMPTY_STRING;
        }
        this.setDriverSelection(driverClass);
        String odaUrl = profileProps.getProperty("odaURL");
        if (odaUrl == null) {
            odaUrl = EMPTY_STRING;
        }
        this.jdbcUrl.setText(odaUrl);
        String odaUser = profileProps.getProperty("odaUser");
        if (odaUser == null) {
            odaUser = EMPTY_STRING;
        }
        this.userName.setText(odaUser);
        String odaPassword = profileProps.getProperty("odaPassword");
        if (odaPassword == null) {
            odaPassword = EMPTY_STRING;
        }
        this.password.setText(odaPassword);
        String odaJndiName = profileProps.getProperty("odaJndiName");
        if (odaJndiName == null) {
            odaJndiName = EMPTY_STRING;
        }
        this.jndiName.setText(odaJndiName);
        this.updateTestButton();
        this.verifyJDBCProperties();
    }

    private void setDriverSelection(String originalDriverClassName) {
        StructuredSelection selection = null;
        JDBCDriverInformation jdbcDriverInfo = this.findJdbcDriverInfo(this.driverChooserCombo, originalDriverClassName);
        if (jdbcDriverInfo != null) {
            selection = new StructuredSelection((Object)jdbcDriverInfo);
        } else {
            if (originalDriverClassName.trim().length() == 0) {
                return;
            }
            JDBCDriverInformation driverInfo = JDBCDriverInformation.newInstance(originalDriverClassName);
            List driverList = this.sortDriverList(JdbcToolKit.getJdbcDriversFromODADir("org.eclipse.birt.report.data.oda.jdbc"));
            driverList.add(0, driverInfo);
            this.driverChooserCombo.setInput((Object)driverList);
            selection = new StructuredSelection((Object)driverInfo);
        }
        this.driverChooserCombo.setSelection((ISelection)selection);
    }

    Properties collectCustomProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        if (!EMPTY_STRING.equals(this.getDriverClass())) {
            props.setProperty("odaDriverClass", this.getDriverClass());
        }
        if (!EMPTY_STRING.equals(this.getDriverURL())) {
            props.setProperty("odaURL", this.getDriverURL());
        }
        if (!EMPTY_STRING.equals(this.getODAUser())) {
            props.setProperty("odaUser", this.getODAUser());
        }
        if (!EMPTY_STRING.equals(this.getODAPassword())) {
            props.setProperty("odaPassword", this.getODAPassword());
        }
        if (!EMPTY_STRING.equals(this.getODAJndiName())) {
            props.setProperty("odaJndiName", this.getODAJndiName());
        }
        props = this.bidiSupportObj.addBidiProperties(props);
        return props;
    }

    private String getODAUser() {
        if (this.userName == null) {
            return EMPTY_STRING;
        }
        return this.getTrimedString(this.userName.getText());
    }

    private String getODAPassword() {
        if (this.password == null) {
            return EMPTY_STRING;
        }
        return this.getTrimedString(this.password.getText());
    }

    private String getODAJndiName() {
        if (this.jndiName == null) {
            return EMPTY_STRING;
        }
        return this.getTrimedString(this.jndiName.getText());
    }

    private String getDriverURL() {
        if (this.jdbcUrl == null) {
            return EMPTY_STRING;
        }
        return this.getTrimedString(this.jdbcUrl.getText());
    }

    private String getDriverClass() {
        if (this.driverChooserCombo == null) {
            return EMPTY_STRING;
        }
        return this.getTrimedString(this.getSelectedDriverClassName());
    }

    private String getTrimedString(String tobeTrimed) {
        if (tobeTrimed != null) {
            tobeTrimed = tobeTrimed.trim();
        }
        return tobeTrimed;
    }

    private List sortDriverList(List driverObjList) {
        Object[] driverObj = driverObjList.toArray();
        Arrays.sort(driverObj, new Comparator(){

            public int compare(Object o1, Object o2) {
                JDBCDriverInformation it1 = (JDBCDriverInformation)o1;
                JDBCDriverInformation it2 = (JDBCDriverInformation)o2;
                int result = 0;
                result = it1.getDriverClassName().compareTo(it2.getDriverClassName());
                return result;
            }
        });
        ArrayList<Object> driverList = new ArrayList<Object>();
        int i = 0;
        while (i < driverObj.length) {
            driverList.add(driverObj[i]);
            ++i;
        }
        return driverList;
    }

    private void setDriverSelection(String originalDriverClassName, ComboViewer driverChooserViewer, List driverList) {
        if (driverList == null || driverList.size() == 0) {
            return;
        }
        StructuredSelection selection = null;
        JDBCDriverInformation jdbcDriverInfo = this.findJdbcDriverInfo(driverChooserViewer, originalDriverClassName);
        if (jdbcDriverInfo != null) {
            selection = new StructuredSelection((Object)jdbcDriverInfo);
        } else {
            if (originalDriverClassName.trim().length() == 0) {
                return;
            }
            JDBCDriverInformation driverInfo = JDBCDriverInformation.newInstance(originalDriverClassName);
            driverList.add(0, driverInfo);
            driverChooserViewer.setInput((Object)driverList);
            selection = new StructuredSelection((Object)driverInfo);
        }
        driverChooserViewer.setSelection((ISelection)selection);
    }

    private JDBCDriverInformation findJdbcDriverInfo(ComboViewer driverChooserViewer, String driverName) {
        JDBCDriverInformation info = null;
        ArrayList infoList = (ArrayList)driverChooserViewer.getInput();
        if (infoList != null) {
            int i = 0;
            while (i < infoList.size()) {
                JDBCDriverInformation jdbcDriverInfo = (JDBCDriverInformation)infoList.get(i);
                if (jdbcDriverInfo.getDriverClassName().equals(driverName)) {
                    info = jdbcDriverInfo;
                    break;
                }
                ++i;
            }
        }
        return info;
    }

    private void addControlListeners() {
        this.jdbcUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!JDBCSelectionPageHelper.this.jdbcUrl.isFocusControl() && JDBCSelectionPageHelper.this.jdbcUrl.getText().trim().length() == 0) {
                    return;
                }
                JDBCSelectionPageHelper.this.verifyJDBCProperties();
                JDBCSelectionPageHelper.this.updateTestButton();
            }
        });
        this.jndiName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!JDBCSelectionPageHelper.this.jndiName.isFocusControl() && JDBCSelectionPageHelper.this.jndiName.getText().trim().length() == 0) {
                    return;
                }
                JDBCSelectionPageHelper.this.verifyJDBCProperties();
                JDBCSelectionPageHelper.this.updateTestButton();
            }
        });
        this.testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JDBCSelectionPageHelper.this.testButton.setEnabled(false);
                try {
                    if (JDBCSelectionPageHelper.this.testConnection()) {
                        MessageDialog.openInformation((Shell)JDBCSelectionPageHelper.this.getShell(), (String)JdbcPlugin.getResourceString("connection.test"), (String)JdbcPlugin.getResourceString("connection.success"));
                    } else {
                        OdaException ex = new OdaException(JdbcPlugin.getResourceString("connection.failed"));
                        ExceptionHandler.showException(JDBCSelectionPageHelper.this.getShell(), JdbcPlugin.getResourceString("connection.test"), JdbcPlugin.getResourceString("connection.failed"), ex);
                    }
                }
                catch (OdaException e1) {
                    ExceptionHandler.showException(JDBCSelectionPageHelper.this.getShell(), JdbcPlugin.getResourceString("connection.test"), JdbcPlugin.getResourceString(e1.getLocalizedMessage()), e1);
                }
                JDBCSelectionPageHelper.this.testButton.setEnabled(true);
            }
        });
        this.manageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JdbcDriverManagerDialog dlg = new JdbcDriverManagerDialog(JDBCSelectionPageHelper.this.getShell());
                JDBCSelectionPageHelper.this.manageButton.setEnabled(false);
                JDBCSelectionPageHelper.this.testButton.setEnabled(false);
                if (dlg.open() == 0) {
                    BusyIndicator.showWhile((Display)(JDBCSelectionPageHelper.this.getShell() == null ? null : JDBCSelectionPageHelper.this.getShell().getDisplay()), (Runnable)new Runnable(){

                        public void run() {
                            JDBCSelectionPageHelper.this.okPressedProcess();
                        }
                    });
                }
                JDBCSelectionPageHelper.this.updateTestButton();
                JDBCSelectionPageHelper.this.manageButton.setEnabled(true);
            }
        });
    }

    private void okPressedProcess() {
        String driverClassName = this.getSelectedDriverClassName();
        List lst = JdbcToolKit.getJdbcDriversFromODADir("org.eclipse.birt.report.data.oda.jdbc");
        this.driverChooserCombo.setInput((Object)this.sortDriverList(lst));
        this.setDriverSelection(driverClassName, this.driverChooserCombo, lst);
    }

    private boolean testConnection() throws OdaException {
        if (!this.isValidDataSource()) {
            return false;
        }
        String url = this.jdbcUrl.getText().trim();
        String userid = this.userName.getText().trim();
        String passwd = this.password.getText();
        String driverName = this.getSelectedDriverClassName();
        String jndiNameValue = this.getODAJndiName();
        if (jndiNameValue.length() == 0) {
            jndiNameValue = null;
        }
        if (this.bidiSupportObj == null) {
            if (this.m_wizardPage instanceof JDBCSelectionWizardPage) {
                this.bidiSupportObj = ((JDBCSelectionWizardPage)this.m_wizardPage).getBidiSupport();
            } else if (this.m_propertyPage instanceof JDBCPropertyPage) {
                this.bidiSupportObj = ((JDBCPropertyPage)this.m_propertyPage).getBidiSupport();
            }
        }
        if (this.bidiSupportObj != null) {
            return DriverLoader.testConnection(driverName, url, jndiNameValue, userid, passwd, this.bidiSupportObj.getMetadataBidiFormat().toString());
        }
        return DriverLoader.testConnection(driverName, url, jndiNameValue, userid, passwd);
    }

    private String getSelectedDriverClassName() {
        IStructuredSelection selection = (IStructuredSelection)this.driverChooserCombo.getSelection();
        if (selection != null && selection.getFirstElement() != null) {
            return ((JDBCDriverInformation)selection.getFirstElement()).getDriverClassName();
        }
        String driverName = this.driverChooserCombo.getCombo().getText();
        if (driverName != null) {
            int count = this.driverChooserCombo.getCombo().getItemCount();
            int i = 0;
            while (i < count) {
                if (driverName.equalsIgnoreCase(this.driverChooserCombo.getCombo().getItem(i))) {
                    return ((JDBCDriverInformation)this.driverChooserCombo.getElementAt(i)).getDriverClassName();
                }
                ++i;
            }
        }
        return driverName;
    }

    private boolean isValidDataSource() {
        return !this.isURLBlank() || !this.isJNDIBlank();
    }

    private boolean isURLBlank() {
        return this.jdbcUrl == null || this.jdbcUrl.getText().trim().length() == 0;
    }

    private boolean isJNDIBlank() {
        return this.jndiName == null || this.jndiName.getText().trim().length() == 0;
    }

    private boolean isDriverClassBlank() {
        return this.getSelectedDriverClassName() == null || this.getSelectedDriverClassName().trim().length() == 0;
    }

    private void updateTestButton() {
        if (this.isDriverClassBlank() || this.isURLBlank() && this.isJNDIBlank()) {
            this.setMessage(EMPTY_URL, 3);
            this.testButton.setEnabled(false);
        } else {
            this.setMessage(this.DEFAULT_MESSAGE);
            if (!this.testButton.isEnabled()) {
                this.testButton.setEnabled(true);
            }
        }
    }

    protected void resetTestAndMngButton() {
        if (this.isURLBlank() && this.isJNDIBlank()) {
            this.setMessage(EMPTY_URL, 3);
            this.testButton.setEnabled(false);
        } else {
            this.setMessage(this.DEFAULT_MESSAGE);
            if (!this.testButton.isEnabled()) {
                this.testButton.setEnabled(true);
            }
        }
        this.manageButton.setEnabled(true);
        this.enableParent((Control)this.manageButton);
    }

    private void enableParent(Control control) {
        Composite parent = control.getParent();
        if (parent == null || parent instanceof Shell) {
            return;
        }
        if (!parent.isEnabled()) {
            parent.setEnabled(true);
        }
        this.enableParent((Control)parent);
    }

    private void verifyJDBCProperties() {
        if (!this.isDriverClassBlank()) {
            if (!this.isJNDIBlank()) {
                this.setPageComplete(true);
            } else if (!this.isURLBlank()) {
                this.setPageComplete(true);
            } else {
                this.setPageComplete(false);
            }
        } else {
            this.setPageComplete(false);
        }
    }

    private Shell getShell() {
        if (this.m_wizardPage != null) {
            return this.m_wizardPage.getShell();
        }
        if (this.m_propertyPage != null) {
            return this.m_propertyPage.getShell();
        }
        return null;
    }

    private void setPageComplete(boolean complete) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setPageComplete(complete);
        } else if (this.m_propertyPage != null) {
            this.m_propertyPage.setValid(complete);
        }
    }

    private void setMessage(String message) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setMessage(message);
        } else if (this.m_propertyPage != null) {
            this.m_propertyPage.setMessage(message);
        }
    }

    private void setMessage(String message, int type) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setMessage(message, type);
        } else if (this.m_propertyPage != null) {
            this.m_propertyPage.setMessage(message, type);
        }
    }

    public void setDefaultMessage(String message) {
        this.DEFAULT_MESSAGE = message;
    }

    private Control getControl() {
        if (this.m_wizardPage != null) {
            return this.m_wizardPage.getControl();
        }
        assert (this.m_propertyPage != null);
        return this.m_propertyPage.getControl();
    }

    public void addBidiSettingsButton(Composite parent, Properties props) {
        this.bidiSupportObj.drawBidiSettingsButton(parent, props);
    }
}

