/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.birt.report.designer.core.model.views.outline.EmbeddedImageNode;
import org.eclipse.birt.report.designer.core.model.views.outline.LibraryNode;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.FragmentResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.PathResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntryFilter;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceFilter;
import org.eclipse.birt.report.designer.internal.ui.views.ViewsTreeProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.lib.explorer.LibraryExplorerPlugin;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.DesignElementEntry;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.EmbeddedImagesEntry;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.LibraryNodeEntry;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.PropertyEntry;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.ReportElementEntry;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.ReportResourceEntry;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.ResourceEntryWrapper;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.SlotEntry;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.StructureEntry;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class LibraryExplorerProvider
extends ViewsTreeProvider {
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ReportResourceEntry) {
            return this.getElementChildren(parentElement, ((ReportResourceEntry)parentElement).getReportElement());
        }
        if (parentElement instanceof ResourceEntryWrapper) {
            if (((ResourceEntryWrapper)parentElement).getType() == 2) {
                return new Object[0];
            }
            if (((ResourceEntryWrapper)parentElement).getType() == 0) {
                Object object = ((ResourceEntryWrapper)parentElement).getAdapter(LibraryHandle.class);
                return this.getElementChildren(parentElement, object);
            }
            if (((ResourceEntryWrapper)parentElement).getType() == 1) {
                Object object = ((ResourceEntryWrapper)parentElement).getAdapter(CssStyleSheetHandle.class);
                return this.getElementChildren(parentElement, object);
            }
        }
        if (parentElement instanceof ResourceEntry) {
            ResourceEntry[] children = ((ResourceEntry)parentElement).getChildren((ResourceEntry.Filter)new ResourceEntryFilter(LibraryExplorerPlugin.getFilterMap().values().toArray(new ResourceFilter[0])));
            ArrayList<ResourceEntry> childrenList = new ArrayList<ResourceEntry>();
            int i = 0;
            while (i < children.length) {
                if (children[i].getAdapter(ReportDesignHandle.class) != null) {
                    childrenList.add(new ResourceEntryWrapper(2, children[i]));
                } else if (children[i].getAdapter(LibraryHandle.class) != null) {
                    childrenList.add(new ResourceEntryWrapper(0, children[i]));
                } else if (children[i].getAdapter(CssStyleSheetHandle.class) != null) {
                    childrenList.add(new ResourceEntryWrapper(1, children[i]));
                } else {
                    childrenList.add(children[i]);
                }
                ++i;
            }
            return childrenList.toArray();
        }
        return super.getChildren(parentElement);
    }

    protected Object[] getElementChildren(Object parentElement, Object object) {
        Object[] children = super.getChildren(object);
        ArrayList<ReportElementEntry> entryList = new ArrayList<ReportElementEntry>();
        int index = 0;
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof DesignElementHandle) {
                entryList.add(new DesignElementEntry((DesignElementHandle)children[i], (ResourceEntry)parentElement));
            } else if (children[i] instanceof SlotHandle) {
                entryList.add(new SlotEntry((SlotHandle)children[i], (ResourceEntry)parentElement));
            } else if (children[i] instanceof EmbeddedImageNode) {
                entryList.add(new EmbeddedImagesEntry((EmbeddedImageNode)children[i], (ResourceEntry)parentElement));
            } else if (children[i] instanceof LibraryNode) {
                entryList.add(new LibraryNodeEntry((LibraryNode)children[i], (ResourceEntry)parentElement));
            } else if (children[i] instanceof PropertyHandle) {
                entryList.add(new PropertyEntry((PropertyHandle)children[i], (ResourceEntry)parentElement));
            } else if (children[i] instanceof StructureHandle) {
                entryList.add(new StructureEntry((StructureHandle)children[i], (ResourceEntry)parentElement, index++));
            } else {
                entryList.add(new ReportElementEntry(children[i], (ResourceEntry)parentElement));
            }
            ++i;
        }
        return entryList.toArray();
    }

    public Image getImage(Object element) {
        if (element instanceof ResourceEntryWrapper) {
            if (((ResourceEntryWrapper)element).getType() == 2) {
                Object object = ((ResourceEntryWrapper)element).getAdapter(ReportDesignHandle.class);
                return super.getImage(object);
            }
            if (((ResourceEntryWrapper)element).getType() == 0) {
                Object object = ((ResourceEntryWrapper)element).getAdapter(LibraryHandle.class);
                return super.getImage(object);
            }
            if (((ResourceEntryWrapper)element).getType() == 1) {
                Object object = ((ResourceEntryWrapper)element).getAdapter(CssStyleSheetHandle.class);
                return super.getImage(object);
            }
        }
        if (element instanceof ResourceEntry) {
            return ((ResourceEntry)element).getImage();
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof ResourceEntryWrapper && ((ResourceEntryWrapper)element).getType() == 2) {
            ReportDesignHandle rptdesign = (ReportDesignHandle)((ResourceEntryWrapper)element).getAdapter(ReportDesignHandle.class);
            String fileName = rptdesign.getFileName();
            return new File(fileName).getName();
        }
        if (element instanceof ResourceEntryWrapper && ((ResourceEntryWrapper)element).getType() == 0) {
            LibraryHandle lib = (LibraryHandle)((ResourceEntryWrapper)element).getAdapter(LibraryHandle.class);
            String fileName = lib.getFileName();
            return new File(fileName).getName();
        }
        if (element instanceof ResourceEntryWrapper && ((ResourceEntryWrapper)element).getType() == 1) {
            CssStyleSheetHandle css = (CssStyleSheetHandle)((ResourceEntryWrapper)element).getAdapter(CssStyleSheetHandle.class);
            String fileName = css.getFileName();
            if (fileName == null || fileName.length() == 0) {
                fileName = "base.css";
            }
            return new File(fileName).getName();
        }
        if (element instanceof ResourceEntry) {
            if (!((ResourceEntry)element).isRoot()) {
                return ((ResourceEntry)element).getName();
            }
            if (element instanceof FragmentResourceEntry) {
                return Messages.getString((String)"FragmentResourceEntry.RootDisplayName");
            }
            if (element instanceof PathResourceEntry) {
                return Messages.getString((String)"PathResourceEntry.RootDisplayName");
            }
        } else if (element instanceof String) {
            return element.toString();
        }
        return super.getText(element);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ResourceEntry) {
            return this.getChildren(element).length > 0;
        }
        return super.hasChildren(element);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput instanceof Object[]) {
            Object[] array = (Object[])oldInput;
            int i = 0;
            while (i < array.length) {
                if (array[i] instanceof ResourceEntry) {
                    ((ResourceEntry)array[i]).dispose();
                }
                ++i;
            }
        }
        super.inputChanged(viewer, oldInput, newInput);
    }

    public Color getForeground(Object resource) {
        Color gray = Display.getCurrent().getSystemColor(16);
        if (resource instanceof ResourceEntry) {
            ResourceEntry node = (ResourceEntry)resource;
            ResourceEntry parent = node.getParent();
            while (parent != null) {
                node = parent;
                parent = node.getParent();
            }
            if (node instanceof FragmentResourceEntry) {
                return gray;
            }
        }
        return super.getForeground(resource);
    }
}

