/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.actions;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.wizards.PublishTemplateWizard;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class PublishTemplateAction
implements IWorkbenchWindowActionDelegate {
    private IFile reportFile = null;
    private boolean selectReport = false;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (this.selectReport) {
            if (this.reportFile != null) {
                String url = this.reportFile.getLocation().toOSString();
                try {
                    ReportDesignHandle handle = SessionHandleAdapter.getInstance().getSessionHandle().openDesign(url);
                    WizardDialog dialog = new WizardDialog(UIUtil.getDefaultShell(), (IWizard)new PublishTemplateWizard(handle));
                    dialog.setPageSize(500, 250);
                    dialog.open();
                    handle.close();
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                    return;
                }
            }
        } else {
            WizardDialog dialog = new WizardDialog(UIUtil.getDefaultShell(), (IWizard)new PublishTemplateWizard((ReportDesignHandle)SessionHandleAdapter.getInstance().getReportDesignHandle()));
            dialog.setPageSize(500, 250);
            dialog.open();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof TreeSelection) {
            IFile file = null;
            if (((TreeSelection)selection).getFirstElement() instanceof IFile) {
                file = (IFile)((TreeSelection)selection).getFirstElement();
            }
            if (file != null) {
                if (file.getFileExtension() != null && (file.getFileExtension().equals("rpttemplate") || file.getFileExtension().equals("rptdesign"))) {
                    this.reportFile = file;
                    this.selectReport = true;
                    action.setEnabled(true);
                } else {
                    this.reportFile = null;
                    this.selectReport = false;
                    action.setEnabled(false);
                }
                return;
            }
        }
        this.reportFile = null;
        this.selectReport = false;
        action.setEnabled(this.isEnable());
    }

    private boolean isEnable() {
        IEditorPart editor = UIUtil.getActiveEditor(true);
        return editor != null && (editor.getEditorInput().getName().endsWith(".rpttemplate") || editor.getEditorInput().getName().endsWith(".rptdesign") || ReportPlugin.getDefault().isReportDesignFile(editor.getEditorInput().getName()));
    }
}

