/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value.css;

import org.eclipse.birt.report.engine.css.engine.CSSContext;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSStylableElement;
import org.eclipse.birt.report.engine.css.engine.value.IdentifierManager;
import org.eclipse.birt.report.engine.css.engine.value.StringMap;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class FontWeightManager
extends IdentifierManager {
    protected static final StringMap values = new StringMap();

    static {
        values.put("bold", CSSValueConstants.BOLD_VALUE);
        values.put("bolder", CSSValueConstants.BOLDER_VALUE);
        values.put("lighter", CSSValueConstants.LIGHTER_VALUE);
        values.put("normal", CSSValueConstants.NORMAL_VALUE);
    }

    public boolean isInheritedProperty() {
        return true;
    }

    public String getPropertyName() {
        return "font-weight";
    }

    public Value getDefaultValue() {
        return CSSValueConstants.NORMAL_VALUE;
    }

    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        if (lu.getLexicalUnitType() == 13) {
            int i = lu.getIntegerValue();
            switch (i) {
                case 100: {
                    return CSSValueConstants.NUMBER_100;
                }
                case 200: {
                    return CSSValueConstants.NUMBER_200;
                }
                case 300: {
                    return CSSValueConstants.NUMBER_300;
                }
                case 400: {
                    return CSSValueConstants.NUMBER_400;
                }
                case 500: {
                    return CSSValueConstants.NUMBER_500;
                }
                case 600: {
                    return CSSValueConstants.NUMBER_600;
                }
                case 700: {
                    return CSSValueConstants.NUMBER_700;
                }
                case 800: {
                    return CSSValueConstants.NUMBER_800;
                }
                case 900: {
                    return CSSValueConstants.NUMBER_900;
                }
            }
            throw this.createInvalidFloatValueDOMException(i);
        }
        return super.createValue(lu, engine);
    }

    public Value createFloatValue(short type, float floatValue) throws DOMException {
        int i;
        if (type == 1 && floatValue == (float)(i = (int)floatValue)) {
            switch (i) {
                case 100: {
                    return CSSValueConstants.NUMBER_100;
                }
                case 200: {
                    return CSSValueConstants.NUMBER_200;
                }
                case 300: {
                    return CSSValueConstants.NUMBER_300;
                }
                case 400: {
                    return CSSValueConstants.NUMBER_400;
                }
                case 500: {
                    return CSSValueConstants.NUMBER_500;
                }
                case 600: {
                    return CSSValueConstants.NUMBER_600;
                }
                case 700: {
                    return CSSValueConstants.NUMBER_700;
                }
                case 800: {
                    return CSSValueConstants.NUMBER_800;
                }
                case 900: {
                    return CSSValueConstants.NUMBER_900;
                }
            }
        }
        throw this.createInvalidFloatValueDOMException(floatValue);
    }

    public CSSValue computeValue(CSSStylableElement elt, CSSEngine engine, int idx, CSSValue value) {
        if (value == CSSValueConstants.BOLDER_VALUE) {
            float fw;
            CSSContext ctx = engine.getCSSContext();
            CSSStylableElement p = (CSSStylableElement)elt.getParent();
            if (p == null) {
                fw = 400.0f;
            } else {
                Value v = (Value)p.getComputedStyle().getProperty(idx);
                fw = v.getFloatValue();
            }
            return this.createFontWeight(ctx.getBolderFontWeight(fw));
        }
        if (value == CSSValueConstants.LIGHTER_VALUE) {
            float fw;
            CSSContext ctx = engine.getCSSContext();
            CSSStylableElement p = (CSSStylableElement)elt.getParent();
            if (p == null) {
                fw = 400.0f;
            } else {
                Value v = (Value)p.getComputedStyle().getProperty(idx);
                fw = v.getFloatValue();
            }
            return this.createFontWeight(ctx.getLighterFontWeight(fw));
        }
        if (value == CSSValueConstants.NORMAL_VALUE) {
            return CSSValueConstants.NUMBER_400;
        }
        if (value == CSSValueConstants.BOLD_VALUE) {
            return CSSValueConstants.NUMBER_700;
        }
        return value;
    }

    protected CSSPrimitiveValue createFontWeight(float f) {
        switch ((int)f) {
            case 100: {
                return CSSValueConstants.NUMBER_100;
            }
            case 200: {
                return CSSValueConstants.NUMBER_200;
            }
            case 300: {
                return CSSValueConstants.NUMBER_300;
            }
            case 400: {
                return CSSValueConstants.NUMBER_400;
            }
            case 500: {
                return CSSValueConstants.NUMBER_500;
            }
            case 600: {
                return CSSValueConstants.NUMBER_600;
            }
            case 700: {
                return CSSValueConstants.NUMBER_700;
            }
            case 800: {
                return CSSValueConstants.NUMBER_800;
            }
        }
        return CSSValueConstants.NUMBER_900;
    }

    public StringMap getIdentifiers() {
        return values;
    }
}

