/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.eventhandler.IImageEventHandler;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.Image;
import org.eclipse.birt.report.engine.script.internal.instance.ImageInstance;
import org.eclipse.birt.report.engine.script.internal.instance.RunningState;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ImageHandle;

public class ImageScriptExecutor
extends ScriptExecutor {
    public static void handleOnPrepare(ImageHandle imageHandle, ExecutionContext context) {
        try {
            Image image = new Image(imageHandle);
            IImageEventHandler eh = ImageScriptExecutor.getEventHandler(imageHandle, context);
            if (eh != null) {
                eh.onPrepare(image, context.getReportContext());
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public static void handleOnCreate(IImageContent content, ExecutionContext context) {
        ReportItemDesign imageDesign = (ReportItemDesign)content.getGenerateBy();
        if (!ImageScriptExecutor.needOnCreate(imageDesign)) {
            return;
        }
        try {
            ImageInstance image = new ImageInstance(content, context, RunningState.CREATE);
            if (ImageScriptExecutor.handleScript(image, imageDesign.getOnCreate(), context).didRun()) {
                return;
            }
            IImageEventHandler eh = ImageScriptExecutor.getEventHandler(imageDesign, context);
            if (eh != null) {
                eh.onCreate(image, context.getReportContext());
            }
        }
        catch (Exception e) {
            ImageScriptExecutor.addException(context, e, imageDesign.getHandle());
        }
    }

    public static void handleOnRender(IImageContent content, ExecutionContext context) {
        ReportItemDesign imageDesign = (ReportItemDesign)content.getGenerateBy();
        if (!ImageScriptExecutor.needOnRender(imageDesign)) {
            return;
        }
        try {
            ImageInstance image = new ImageInstance(content, context, RunningState.RENDER);
            if (ImageScriptExecutor.handleScript(image, imageDesign.getOnRender(), context).didRun()) {
                return;
            }
            IImageEventHandler eh = ImageScriptExecutor.getEventHandler(imageDesign, context);
            if (eh != null) {
                eh.onRender(image, context.getReportContext());
            }
        }
        catch (Exception e) {
            ImageScriptExecutor.addException(context, e, imageDesign.getHandle());
        }
    }

    public static void handleOnPageBreak(IImageContent content, ExecutionContext context) {
        ReportItemDesign imageDesign = (ReportItemDesign)content.getGenerateBy();
        if (!ImageScriptExecutor.needOnPageBreak(imageDesign)) {
            return;
        }
        try {
            ImageInstance image = new ImageInstance(content, context, RunningState.PAGEBREAK);
            if (ImageScriptExecutor.handleScript(image, imageDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            IImageEventHandler eh = ImageScriptExecutor.getEventHandler(imageDesign, context);
            if (eh != null) {
                eh.onPageBreak(image, context.getReportContext());
            }
        }
        catch (Exception e) {
            ImageScriptExecutor.addException(context, e, imageDesign.getHandle());
        }
    }

    private static IImageEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        try {
            return (IImageEventHandler)ImageScriptExecutor.getInstance(design, context);
        }
        catch (ClassCastException e) {
            ImageScriptExecutor.addClassCastException(context, e, design.getHandle(), IImageEventHandler.class);
        }
        catch (EngineException e) {
            ImageScriptExecutor.addException(context, (Exception)((Object)e), design.getHandle());
        }
        return null;
    }

    private static IImageEventHandler getEventHandler(ImageHandle handle, ExecutionContext context) {
        try {
            return (IImageEventHandler)ImageScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            ImageScriptExecutor.addClassCastException(context, e, (DesignElementHandle)handle, IImageEventHandler.class);
        }
        catch (EngineException e) {
            ImageScriptExecutor.addException(context, (Exception)((Object)e), (DesignElementHandle)handle);
        }
        return null;
    }
}

