/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabGroupBandExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabMeasureExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabReportItemExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.EdgeGroup;
import org.eclipse.birt.report.item.crosstab.core.re.executor.GroupUtil;
import org.w3c.dom.css.CSSValue;

public class CrosstabGroupExecutor
extends BaseCrosstabExecutor {
    private static final Logger logger = Logger.getLogger(CrosstabGroupExecutor.class.getName());
    private int currentGroupIndex;
    private EdgeCursor rowCursor;
    private List groupCursors;
    private LevelViewHandle currentLevel;
    private int currentDimensionIndex;
    private int currentLevelIndex;
    private int totalMeasureCount;
    private List elements;
    private int currentElement;
    private boolean endGroup;
    private boolean hasGroup;
    boolean notifyNextGroupPageBreak;

    public CrosstabGroupExecutor(BaseCrosstabExecutor parent, int groupIndex, EdgeCursor rowCursor) {
        super(parent);
        this.currentGroupIndex = groupIndex;
        this.rowCursor = rowCursor;
    }

    public void close() {
        if (this.hasGroup) {
            try {
                this.handleGroupPageBreakAfter();
            }
            catch (OLAPException e) {
                logger.log(Level.SEVERE, Messages.getString("CrosstabGroupExecutor.error.close.executor"), e);
            }
        }
        super.close();
        this.groupCursors = null;
        this.currentLevel = null;
        this.elements = null;
    }

    public IContent execute() {
        ITableGroupContent content = this.context.getReportContent().createTableGroupContent();
        this.initializeContent((IContent)content, null);
        this.prepareChildren();
        return content;
    }

    private void prepareChildren() {
        boolean bl = this.hasGroup = this.rowGroups.size() > 0 && this.rowCursor != null;
        if (this.hasGroup) {
            try {
                this.totalMeasureCount = this.crosstabItem.getMeasureCount();
                this.groupCursors = this.rowCursor.getDimensionCursor();
                EdgeGroup group = (EdgeGroup)this.rowGroups.get(this.currentGroupIndex);
                this.currentDimensionIndex = group.dimensionIndex;
                this.currentLevelIndex = group.levelIndex;
                if (this.currentDimensionIndex >= 0 && this.currentLevelIndex >= 0) {
                    this.currentLevel = this.crosstabItem.getDimension(0, this.currentDimensionIndex).getLevel(this.currentLevelIndex);
                }
                this.handleGroupPageBreakInside();
                this.handleGroupPageBreakBefore();
                this.collectExecutable();
            }
            catch (OLAPException e) {
                logger.log(Level.SEVERE, Messages.getString("CrosstabGroupExecutor.error.prepare.group"), e);
            }
        } else {
            this.elements = new ArrayList();
            this.currentElement = 0;
            this.elements.add(new CrosstabMeasureExecutor(this));
        }
    }

    private boolean isCurrentLevelLeafGroup() throws OLAPException {
        return GroupUtil.isLeafGroup(this.rowCursor.getDimensionCursor(), this.currentGroupIndex);
    }

    private void handleGroupPageBreakInside() {
        String pageBreakInside;
        if (this.currentLevel != null && "avoid".equals(pageBreakInside = this.currentLevel.getPageBreakInside())) {
            this.getContent().getStyle().setProperty(57, (CSSValue)IStyle.AVOID_VALUE);
        }
    }

    private void handleGroupPageBreakBefore() throws OLAPException {
        if (this.currentLevel != null) {
            String pageBreakAfter;
            boolean isFirst = ((DimensionCursor)this.groupCursors.get(this.currentGroupIndex)).isFirst();
            String pageBreakBefore = this.currentLevel.getPageBreakBefore();
            if ("always".equals(pageBreakBefore) || "always-excluding-first".equals(pageBreakBefore) && !isFirst) {
                this.getContent().getStyle().setProperty(47, (CSSValue)IStyle.ALWAYS_VALUE);
            }
            if ("always".equals(pageBreakAfter = this.currentLevel.getPageBreakAfter())) {
                this.getContent().getStyle().setProperty(58, (CSSValue)IStyle.ALWAYS_VALUE);
            }
        }
        boolean hasPageBreak = false;
        IReportItemExecutor parentExecutor = this.getParent();
        if (parentExecutor instanceof CrosstabGroupExecutor || parentExecutor instanceof CrosstabReportItemExecutor) {
            if (parentExecutor instanceof CrosstabGroupExecutor) {
                if (((CrosstabGroupExecutor)parentExecutor).notifyNextGroupPageBreak) {
                    ((CrosstabGroupExecutor)parentExecutor).notifyNextGroupPageBreak = false;
                    hasPageBreak = true;
                }
            } else if (((CrosstabReportItemExecutor)parentExecutor).notifyNextGroupPageBreak) {
                ((CrosstabReportItemExecutor)parentExecutor).notifyNextGroupPageBreak = false;
                hasPageBreak = true;
            }
        }
        if (hasPageBreak) {
            this.getContent().getStyle().setProperty(47, (CSSValue)IStyle.ALWAYS_VALUE);
        }
    }

    private void handleGroupPageBreakAfter() throws OLAPException {
        if (this.currentLevel != null) {
            String pageBreakAfter = this.currentLevel.getPageBreakAfter();
            IReportItemExecutor parentExecutor = this.getParent();
            if ((parentExecutor instanceof CrosstabGroupExecutor || parentExecutor instanceof CrosstabReportItemExecutor) && "always-excluding-last".equals(pageBreakAfter) && !this.rowCursor.isLast() && (parentExecutor instanceof CrosstabGroupExecutor || parentExecutor instanceof CrosstabReportItemExecutor)) {
                if (parentExecutor instanceof CrosstabGroupExecutor) {
                    ((CrosstabGroupExecutor)parentExecutor).notifyNextGroupPageBreak = true;
                } else {
                    ((CrosstabReportItemExecutor)parentExecutor).notifyNextGroupPageBreak = true;
                }
            }
        }
    }

    private void collectExecutable() throws OLAPException {
        CrosstabGroupBandExecutor bandExecutor;
        this.elements = new ArrayList();
        this.currentElement = 0;
        this.endGroup = false;
        int startingGroupIndex = GroupUtil.getStartingGroupLevel(this.rowCursor, this.groupCursors);
        if (startingGroupIndex <= this.currentGroupIndex + 1 && this.totalMeasureCount > 0 && !this.isCurrentLevelLeafGroup() && this.currentLevel != null && this.currentLevel.getAggregationHeader() != null && "before".equals(this.currentLevel.getAggregationHeaderLocation())) {
            bandExecutor = new CrosstabGroupBandExecutor(this, this.currentDimensionIndex, this.currentLevelIndex, 1);
            this.elements.add(bandExecutor);
        }
        if (this.currentGroupIndex < this.rowGroups.size() - 1) {
            CrosstabGroupExecutor groupExecutor = new CrosstabGroupExecutor(this, this.currentGroupIndex + 1, this.rowCursor);
            this.elements.add(groupExecutor);
        } else {
            bandExecutor = new CrosstabGroupBandExecutor(this, this.currentDimensionIndex, this.currentLevelIndex, 0);
            this.elements.add(bandExecutor);
        }
        int endingGroupIndex = GroupUtil.getEndingGroupLevel(this.rowCursor, this.groupCursors);
        if (endingGroupIndex <= this.currentGroupIndex + 1) {
            if (this.totalMeasureCount > 0 && !this.isCurrentLevelLeafGroup() && this.currentLevel != null && this.currentLevel.getAggregationHeader() != null && "after".equals(this.currentLevel.getAggregationHeaderLocation())) {
                CrosstabGroupBandExecutor bandExecutor2 = new CrosstabGroupBandExecutor(this, this.currentDimensionIndex, this.currentLevelIndex, 2);
                this.elements.add(bandExecutor2);
            }
            this.endGroup = true;
        }
    }

    public IReportItemExecutor getNextChild() {
        if (this.currentElement < this.elements.size()) {
            return (IReportItemExecutor)this.elements.get(this.currentElement++);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public boolean hasNextChild() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

