/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui;

import java.util.HashMap;
import org.eclipse.birt.report.designer.core.commands.CreateCommand;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabExtendedItemFactory;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateRequest;

public class CreateCrosstabHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(Messages.getString((String)"InsertAction.text"));
        ExtendedItemHandle handle = null;
        try {
            String name = ReportPlugin.getDefault().getCustomName("Crosstab");
            handle = CrosstabExtendedItemFactory.createCrosstabReportItem((ModuleHandle)SessionHandleAdapter.getInstance().getReportDesignHandle(), null, (String)name);
        }
        catch (Exception e) {
            stack.rollback();
            throw new ExecutionException(e.getLocalizedMessage(), (Throwable)e);
        }
        IEvaluationContext context = (IEvaluationContext)event.getApplicationContext();
        EditPart targetEditPart = (EditPart)context.getVariable("targetEditPart");
        if (targetEditPart == null) {
            targetEditPart = UIUtil.getCurrentEditPart();
        }
        Object parentModel = DNDUtil.unwrapToModel((Object)targetEditPart.getModel());
        CreateRequest request = (CreateRequest)context.getVariable("request");
        if (request != null) {
            request.getExtendedData().put("newObject", handle);
            try {
                targetEditPart.getCommand((Request)request).execute();
                stack.commit();
            }
            catch (Exception exception) {
                stack.rollback();
            }
        } else {
            HashMap<String, ExtendedItemHandle> map = new HashMap<String, ExtendedItemHandle>();
            map.put("newObject", handle);
            CreateCommand command = new CreateCommand(map);
            try {
                if (parentModel instanceof DesignElementHandle) {
                    DesignElementHandle parentHandle = (DesignElementHandle)parentModel;
                    if (parentHandle.getDefn().isContainer() && (parentHandle.canContain(DEUtil.getDefaultSlotID((Object)parentHandle), (DesignElementHandle)handle) || parentHandle.canContain(DEUtil.getDefaultContentName((Object)parentHandle), (DesignElementHandle)handle))) {
                        command.setParent((Object)parentHandle);
                    } else {
                        if (parentHandle.getContainerSlotHandle() != null) {
                            command.setAfter((Object)parentHandle.getContainerSlotHandle().get(parentHandle.getIndex() + 1));
                        } else if (parentHandle.getContainerPropertyHandle() != null) {
                            command.setAfter(parentHandle.getContainerPropertyHandle().get(parentHandle.getIndex() + 1));
                        }
                        DesignElementHandle container = parentHandle.getContainer();
                        if (container instanceof ListHandle) {
                            command.setParent((Object)parentHandle.getContainerSlotHandle());
                        } else {
                            command.setParent((Object)container);
                        }
                    }
                } else if (parentModel instanceof SlotHandle) {
                    command.setParent(parentModel);
                } else {
                    command.setParent((Object)SessionHandleAdapter.getInstance().getReportDesignHandle());
                }
                command.execute();
                stack.commit();
            }
            catch (Exception exception) {
                stack.rollback();
            }
        }
        if (parentModel instanceof LibraryHandle) {
            try {
                HandleAdapterFactory.getInstance().getLibraryHandleAdapter().setCurrentEditorModel((Object)handle, "create element");
            }
            catch (Exception exception) {}
        }
        return handle;
    }
}

