/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cmdline.internal;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.buckminster.cmdline.AbstractCommand;
import org.eclipse.buckminster.cmdline.CommandInfo;
import org.eclipse.buckminster.cmdline.Messages;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.parser.InvalidOptionValueException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListCommands
extends AbstractCommand {
    private static final int LONG = 1;
    private static final int NORMAL = 2;
    private static final int SHORT = 3;
    private static final OptionDescriptor DISABLED_OPT = new OptionDescriptor(null, "__disabled", 1);
    private static final OptionDescriptor HIDDEN_OPT = new OptionDescriptor(null, "__hidden", 1);
    private static final OptionDescriptor STYLE_OPT = new OptionDescriptor(null, "style", 3);
    private boolean showDisabled = false;
    private boolean showHidden = false;
    private int style = 2;

    private static int parseStyle(String styleStr) throws InvalidOptionValueException {
        int style;
        if ("long".equalsIgnoreCase(styleStr)) {
            style = 1;
        } else if ("normal".equalsIgnoreCase(styleStr)) {
            style = 2;
        } else if ("short".equalsIgnoreCase(styleStr)) {
            style = 3;
        } else {
            throw new InvalidOptionValueException(STYLE_OPT.getLongName(), styleStr);
        }
        return style;
    }

    @Override
    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        appendHere.add(HIDDEN_OPT);
        appendHere.add(DISABLED_OPT);
        appendHere.add(STYLE_OPT);
        super.getOptionDescriptors(appendHere);
    }

    @Override
    protected void handleOption(Option option) throws Exception {
        if (option.is(HIDDEN_OPT)) {
            this.showHidden = true;
        } else if (option.is(DISABLED_OPT)) {
            this.showDisabled = true;
        } else if (option.is(STYLE_OPT)) {
            this.style = ListCommands.parseStyle(option.getValue().toUpperCase());
        } else {
            super.handleOption(option);
        }
    }

    @Override
    protected int run(IProgressMonitor monitor) throws Exception {
        CommandInfo[] implementors = CommandInfo.getImplementors();
        switch (this.style) {
            case 3: {
                this.showShort(implementors);
                break;
            }
            case 2: {
                this.showNormal(implementors);
                break;
            }
            default: {
                this.showLong(implementors);
            }
        }
        MonitorUtils.complete((IProgressMonitor)monitor);
        return 0;
    }

    private boolean shouldShow(CommandInfo cmdInfo) {
        int s = cmdInfo.getStatus();
        if (s == 2 && !this.showHidden) {
            return false;
        }
        return s != 3 || this.showDisabled;
    }

    private void showLong(CommandInfo[] implementors) {
        PrintStream out = System.out;
        out.println(Messages.ListCommands_Available_commands_by_namespace);
        SortedMap<String, List<CommandInfo>> implementorsByNamespace = this.sortImplementorsByNamespace(implementors);
        for (Map.Entry<String, List<CommandInfo>> entry : implementorsByNamespace.entrySet()) {
            List<CommandInfo> implementorsForNamespace = entry.getValue();
            Collections.sort(implementorsForNamespace, new Comparator<CommandInfo>(){

                @Override
                public int compare(CommandInfo o1, CommandInfo o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            String namespace = entry.getKey();
            int top = implementorsForNamespace.size();
            int idx = 0;
            while (idx < top) {
                CommandInfo ci = implementorsForNamespace.get(idx);
                if (this.shouldShow(ci)) {
                    if (namespace != null) {
                        out.print("  (");
                        out.print(namespace);
                        out.println(")");
                        namespace = null;
                    }
                    out.print("    ");
                    out.print(ci.getName());
                    Object[] aliases = ci.getAliases();
                    if (aliases.length > 0) {
                        out.print(" (");
                        out.print(aliases.length);
                        out.print(" alias");
                        out.println(aliases.length > 1 ? "es)" : ")");
                        Arrays.sort(aliases);
                        int i = 0;
                        while (i < aliases.length) {
                            out.print("      ");
                            out.println((String)aliases[i]);
                            ++i;
                        }
                    } else {
                        out.println();
                    }
                }
                ++idx;
            }
        }
    }

    private void showNormal(CommandInfo[] implementors) {
        PrintStream out = System.out;
        out.println(Messages.ListCommands_Available_commands_including_aliases);
        ArrayList<String> names = new ArrayList<String>();
        int idx = 0;
        while (idx < implementors.length) {
            CommandInfo cmdInfo = implementors[idx];
            if (this.shouldShow(cmdInfo)) {
                String[] allNames = cmdInfo.getAllNames();
                int i = 0;
                while (i < allNames.length) {
                    names.add(allNames[i]);
                    ++i;
                }
            }
            ++idx;
        }
        Collections.sort(names);
        int top = names.size();
        int idx2 = 0;
        while (idx2 < top) {
            out.print("  ");
            out.println((String)names.get(idx2));
            ++idx2;
        }
    }

    private void showShort(CommandInfo[] implementors) {
        PrintStream out = System.out;
        ArrayList<String> names = new ArrayList<String>();
        int idx = 0;
        while (idx < implementors.length) {
            CommandInfo cmdInfo = implementors[idx];
            if (this.shouldShow(cmdInfo)) {
                names.add(cmdInfo.getFullName());
            }
            ++idx;
        }
        Collections.sort(names);
        int top = names.size();
        int idx2 = 0;
        while (idx2 < top) {
            out.println((String)names.get(idx2));
            ++idx2;
        }
    }

    private SortedMap<String, List<CommandInfo>> sortImplementorsByNamespace(CommandInfo[] implementors) {
        TreeMap<String, List<CommandInfo>> implementorsByNamespace = new TreeMap<String, List<CommandInfo>>();
        int idx = 0;
        while (idx < implementors.length) {
            CommandInfo ci = implementors[idx];
            String namespace = ci.getNamespace();
            ArrayList<CommandInfo> ciList = (ArrayList<CommandInfo>)implementorsByNamespace.get(namespace);
            if (ciList == null) {
                ciList = new ArrayList<CommandInfo>();
            }
            ciList.add(ci);
            implementorsByNamespace.put(namespace, ciList);
            ++idx;
        }
        return implementorsByNamespace;
    }
}

