/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.util.List;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.commands.Launch;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackgroundLaunch
extends Launch {
    private static final OptionDescriptor LAUNCH_DESCRIPTOR = new OptionDescriptor('l', "launch", 3);
    private static final OptionDescriptor IGNORE_MISSING = new OptionDescriptor(null, "ignoremissing", 2);
    private String launchName;
    private boolean ignoreMissing = false;

    @Override
    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        appendHere.add(LAUNCH_DESCRIPTOR);
        appendHere.add(IGNORE_MISSING);
        super.getOptionDescriptors(appendHere);
    }

    @Override
    protected void handleOption(Option option) throws Exception {
        super.handleOption(option);
        if (option.is(LAUNCH_DESCRIPTOR)) {
            this.launchName = option.getValue();
        } else if (option.is(IGNORE_MISSING)) {
            this.ignoreMissing = true;
        }
    }

    @Override
    protected int internalRun(IProgressMonitor monitor) throws Exception {
        if (this.launchName == null && !this.ignoreMissing) {
            throw new UsageException(Messages.Launch_No_launch_config);
        }
        IResource launchFile = ResourcesPlugin.getWorkspace().getRoot().findMember(this.launchName);
        if (launchFile == null || launchFile.getType() != 1 || !launchFile.exists()) {
            if (this.ignoreMissing) {
                return 0;
            }
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Launch_Cannot_open_launch_config, (Object)this.launchName), (Object[])new Object[0]);
        }
        ILaunchConfiguration launchConfiguration = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration((IFile)launchFile);
        final ILaunch launch = launchConfiguration.launch(this.getLaunchMode(), monitor);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    launch.terminate();
                }
                catch (DebugException e) {
                    e.printStackTrace();
                }
            }
        });
        return 0;
    }
}

