/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.commands.WorkspaceCommand;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Launch
extends WorkspaceCommand {
    private static final OptionDescriptor LAUNCH_DESCRIPTOR = new OptionDescriptor('l', "launch", 3);
    private static final OptionDescriptor STDOUT_DESCRIPTOR = new OptionDescriptor(null, "stdout", 2);
    private static final OptionDescriptor STDERR_DESCRIPTOR = new OptionDescriptor(null, "stderr", 2);
    private String launchName;
    private String stdOutFile;
    private String stdErrFile;
    private IStreamMonitor[] stdOut;
    private IStreamMonitor[] stdErr;
    private List<StreamListener> listeners = new ArrayList<StreamListener>();
    private ILaunch launch;

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IStreamMonitor[] getRawStdErr() {
        return (IStreamMonitor[])this.stdErr.clone();
    }

    public IStreamMonitor[] getRawStdOut() {
        return (IStreamMonitor[])this.stdOut.clone();
    }

    public String getStdErr() {
        StringBuffer content = new StringBuffer();
        IStreamMonitor[] iStreamMonitorArray = this.stdErr;
        int n = this.stdErr.length;
        int n2 = 0;
        while (n2 < n) {
            IStreamMonitor err = iStreamMonitorArray[n2];
            content.append(err.getContents());
            ++n2;
        }
        return content.toString();
    }

    public String getStdOut() {
        StringBuffer content = new StringBuffer();
        IStreamMonitor[] iStreamMonitorArray = this.stdOut;
        int n = this.stdOut.length;
        int n2 = 0;
        while (n2 < n) {
            IStreamMonitor out = iStreamMonitorArray[n2];
            content.append(out.getContents());
            ++n2;
        }
        return content.toString();
    }

    protected String getLaunchMode() {
        return "run";
    }

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        appendHere.add(LAUNCH_DESCRIPTOR);
        appendHere.add(STDOUT_DESCRIPTOR);
        appendHere.add(STDERR_DESCRIPTOR);
        super.getOptionDescriptors(appendHere);
    }

    protected void handleOption(Option option) throws Exception {
        if (option.is(LAUNCH_DESCRIPTOR)) {
            this.launchName = option.getValue();
        } else if (option.is(STDOUT_DESCRIPTOR)) {
            this.stdOutFile = option.getValue() == null ? "-" : option.getValue();
        } else if (option.is(STDERR_DESCRIPTOR)) {
            this.stdErrFile = option.getValue() == null ? "-" : option.getValue();
        } else {
            super.handleOption(option);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int internalRun(IProgressMonitor monitor) throws Exception {
        if (this.launchName == null) {
            throw new UsageException(Messages.Launch_No_launch_config);
        }
        launchFile = ResourcesPlugin.getWorkspace().getRoot().findMember(this.launchName);
        if (launchFile == null) throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Launch_Cannot_open_launch_config, (Object)this.launchName), (Object[])new Object[0]);
        if (launchFile.getType() != 1) throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Launch_Cannot_open_launch_config, (Object)this.launchName), (Object[])new Object[0]);
        if (!launchFile.exists()) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Launch_Cannot_open_launch_config, (Object)this.launchName), (Object[])new Object[0]);
        }
        launchConfiguration = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration((IFile)launchFile);
        this.launch = launchConfiguration.launch(this.getLaunchMode(), monitor);
        processes = this.launch.getProcesses();
        this.stdOut = new IStreamMonitor[processes.length];
        this.stdErr = new IStreamMonitor[processes.length];
        i = 0;
        while (i < processes.length) {
            this.stdOut[i] = processes[i].getStreamsProxy().getOutputStreamMonitor();
            if (this.stdOutFile != null) {
                new StreamListener(this.stdOut[i], this.stdOutFile, true);
            }
            this.stdErr[i] = processes[i].getStreamsProxy().getErrorStreamMonitor();
            if (this.stdErrFile != null) {
                new StreamListener(this.stdErr[i], this.stdErrFile, false);
            }
            ++i;
        }
        try {
            while (!this.launch.isTerminated()) {
                Thread.sleep(500L);
            }
            result = 0;
            var9_6 = processes;
            var8_7 = processes.length;
            var7_8 = 0;
            while (var7_8 < var8_7) {
                p = var9_6[var7_8];
                if (p.getExitValue() != 0) {
                    CorePlugin.getLogger().warning(NLS.bind((String)Messages.Launch_Terminated_with_exit_status, (Object)p.getLabel(), (Object)p.getExitValue()), new Object[0]);
                    result = p.getExitValue();
                }
                ++var7_8;
            }
            var11_10 = result;
            return var11_10;
        }
        finally {
            ** for (listener : this.listeners)
        }
lbl-1000:
        // 1 sources

        {
            listener.close();
            continue;
        }
lbl44:
        // 1 sources

        return var11_10;
    }

    private final class StreamListener
    implements IStreamListener {
        private PrintStream stream;

        public StreamListener(IStreamMonitor monitor, String outputFile, boolean stdout) {
            Launch.this.listeners.add(this);
            if ("-".equals(outputFile)) {
                this.stream = stdout ? Logger.getOutStream() : Logger.getErrStream();
            } else {
                try {
                    this.stream = new PrintStream(outputFile);
                }
                catch (FileNotFoundException e) {
                    CorePlugin.getLogger().error((Throwable)e, Messages.Launch_Cannot_open_stream, new Object[]{outputFile});
                    this.stream = stdout ? Logger.getOutStream() : Logger.getErrStream();
                }
            }
            this.stream.print(monitor.getContents());
            monitor.addListener((IStreamListener)this);
        }

        public void close() {
            if (this.stream != Logger.getOutStream() && this.stream != Logger.getErrStream()) {
                this.stream.close();
            }
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            this.stream.print(text);
            if (monitor instanceof IFlushableStreamMonitor) {
                IFlushableStreamMonitor flushableMonitor = (IFlushableStreamMonitor)monitor;
                flushableMonitor.flushContents();
            }
        }
    }
}

