/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.SimpleErrorExitException;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.commands.WorkspaceCommand;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkspaceInitCommand
extends WorkspaceCommand {
    static final OptionDescriptor CONTINUE_ON_ERROR = new OptionDescriptor('C', "continueonerror", 1);
    static final OptionDescriptor MATERIALIZER = new OptionDescriptor('M', "materializer", 3);
    static final OptionDescriptor TEMPLATE = new OptionDescriptor('T', "template", 3);
    private boolean continueOnError;
    private String materializer;
    private URL template;

    private static boolean isFolderEmpty(File folder) {
        String[] names = folder.list();
        if (names != null) {
            int idx = names.length;
            while (--idx >= 0) {
                if (WorkspaceInitCommand.isFolderEmpty(new File(folder, names[idx]))) continue;
                return false;
            }
        }
        return !folder.isFile();
    }

    public void setContinueOnError(boolean flag) {
        this.continueOnError = flag;
    }

    public void setMaterializer(String materializer) {
        this.materializer = materializer;
    }

    public void setTemplate(URL template) {
        this.template = template;
    }

    protected String getMaterializer() {
        return this.materializer;
    }

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        super.getOptionDescriptors(appendHere);
        appendHere.add(CONTINUE_ON_ERROR);
        appendHere.add(MATERIALIZER);
        appendHere.add(TEMPLATE);
    }

    protected void handleOption(Option option) throws Exception {
        if (option.is(CONTINUE_ON_ERROR)) {
            this.setContinueOnError(true);
        } else if (option.is(TEMPLATE)) {
            this.setTemplate(URLUtils.normalizeToURL((String)option.getValue()));
        } else if (option.is(MATERIALIZER)) {
            this.setMaterializer(option.getValue());
        } else {
            super.handleOption(option);
        }
    }

    @Override
    protected void initWorkspace(IProgressMonitor monitor) throws Exception {
        if (this.template != null) {
            this.initWorkspaceFromTemplate();
        }
        super.initWorkspace(monitor);
    }

    protected void initWorkspaceFromTemplate() throws Exception {
        try {
            File fileTemplate;
            File wsRoot = FileUtils.getFile(FileLocator.toFileURL((URL)Platform.getInstanceLocation().getURL()));
            if (!WorkspaceInitCommand.isFolderEmpty(wsRoot)) {
                throw new SimpleErrorExitException(NLS.bind((String)Messages.Workspace_at_0_is_not_empty, (Object)wsRoot));
            }
            NullProgressMonitor nullMon = new NullProgressMonitor();
            URL templateURL = FileLocator.toFileURL((URL)this.template);
            String path = templateURL.getPath();
            if (path.endsWith(".zip") || path.endsWith(".jar")) {
                File dest = FileUtils.createTempFolder("bmtpl", ".tmp");
                BufferedInputStream input = null;
                try {
                    input = new BufferedInputStream(templateURL.openStream());
                    FileUtils.unzip(input, null, dest, ConflictResolution.UPDATE, (IProgressMonitor)nullMon);
                }
                catch (Throwable throwable) {
                    IOUtils.close(input);
                    throw throwable;
                }
                IOUtils.close((Closeable)input);
                fileTemplate = dest;
            } else {
                fileTemplate = FileUtils.getFile(templateURL);
                if (fileTemplate == null) {
                    throw new SimpleErrorExitException(Messages.Only_zip_and_jar_files_allowed_for_remote_workspace_templates);
                }
                if (!fileTemplate.isAbsolute()) {
                    fileTemplate = fileTemplate.getAbsoluteFile();
                }
                if (!fileTemplate.isDirectory()) {
                    throw new SimpleErrorExitException(Messages.Only_folders_zip_and_jar_files_can_be_uses_as_workspace_template);
                }
            }
            FileUtils.deepCopyUnchecked(fileTemplate, wsRoot, (IProgressMonitor)nullMon);
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)nullMon);
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    protected abstract int internalRun(boolean var1, IProgressMonitor var2) throws Exception;

    @Override
    protected final int internalRun(IProgressMonitor monitor) throws Exception {
        return this.internalRun(this.continueOnError, monitor);
    }

    protected boolean isContinueOnError() {
        return this.continueOnError;
    }
}

