/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.common.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.common.model.ValueHolderFilter;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Replace
extends ValueHolderFilter {
    public static final String TAG = "replace";
    public static final String MATCH_TAG = "match";
    public static final String ATTR_PATTERN = "pattern";
    public static final String ATTR_REPLACEMENT = "replacement";
    public static final String ATTR_QUOTE_PATTERN = "quotePattern";
    private final ArrayList<Match> matchers = new ArrayList();

    public void addMatch(Match match) {
        this.matchers.add(match);
    }

    @Override
    public String checkedGetValue(Map<String, ? extends Object> props, int recursionGuard) {
        String resolved = this.checkedGetSourceValue(props, recursionGuard);
        if (resolved == null || "".equals(resolved)) {
            return "";
        }
        for (Match match : this.matchers) {
            String result = match.match(resolved);
            if (result == null) continue;
            return result;
        }
        return resolved;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.matchers.equals(((Replace)((Object)o)).matchers);
    }

    public String getDefaultTag() {
        return TAG;
    }

    @Override
    public int hashCode() {
        int hc = super.hashCode();
        hc = 37 * hc + this.matchers.hashCode();
        return hc;
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        if (this.matchers.size() == 1) {
            this.matchers.get(0).addAttributes(attrs);
        }
    }

    @Override
    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        super.emitElements(handler, namespace, prefix);
        int top = this.matchers.size();
        if (top > 1) {
            int idx = 0;
            while (idx < top) {
                Match match = this.matchers.get(idx);
                match.toSax(handler, namespace, prefix, match.getDefaultTag());
                ++idx;
            }
        }
    }

    public static final class Match
    extends AbstractSaxableElement {
        private final Pattern pattern;
        private final String patternString;
        private final String replacement;
        private final boolean quotePattern;

        public Match(String pattern, String replacement, boolean quotePattern) {
            this.patternString = pattern;
            this.quotePattern = quotePattern;
            this.replacement = replacement;
            if (quotePattern) {
                pattern = Pattern.quote(pattern);
            }
            this.pattern = Pattern.compile(pattern);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Match)) {
                return false;
            }
            return this.quotePattern == ((Match)((Object)o)).quotePattern && this.patternString.equals(((Match)((Object)o)).patternString) && this.replacement.equals(((Match)((Object)o)).replacement);
        }

        public String getDefaultTag() {
            return Replace.MATCH_TAG;
        }

        public int hashCode() {
            int hc = this.patternString.hashCode();
            hc = 37 * hc + this.replacement.hashCode();
            hc = 37 * hc + (this.quotePattern ? 17 : 0);
            return hc;
        }

        protected void addAttributes(AttributesImpl attrs) throws SAXException {
            Utils.addAttribute((AttributesImpl)attrs, (String)Replace.ATTR_PATTERN, (String)this.patternString);
            Utils.addAttribute((AttributesImpl)attrs, (String)Replace.ATTR_REPLACEMENT, (String)this.replacement);
            if (this.quotePattern) {
                Utils.addAttribute((AttributesImpl)attrs, (String)Replace.ATTR_QUOTE_PATTERN, (String)"true");
            }
        }

        String match(String resolved) {
            Matcher matcher = this.pattern.matcher(resolved);
            if (matcher.find()) {
                StringBuffer sb = new StringBuffer();
                do {
                    matcher.appendReplacement(sb, this.replacement);
                } while (matcher.find());
                matcher.appendTail(sb);
                return sb.toString();
            }
            return null;
        }
    }
}

