/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.common.model;

import java.util.List;
import org.eclipse.buckminster.core.common.model.RxPart;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RxGroup
extends RxPart {
    public static final String TAG = "group";
    private final List<RxPart> parts;

    public RxGroup(String name, boolean optional, List<RxPart> parts) {
        super(name, optional);
        this.parts = Utils.createUnmodifiableList(parts);
    }

    @Override
    public void addPattern(StringBuilder bld, List<RxPart> namedParts) throws CoreException {
        if (this.getName() != null) {
            bld.append('(');
            namedParts.add(this);
        } else if (this.isOptional()) {
            bld.append("(?:");
        }
        for (RxPart part : this.parts) {
            part.addPattern(bld, namedParts);
        }
        if (this.getName() != null) {
            bld.append(')');
        } else if (this.isOptional()) {
            bld.append(")?");
        }
    }

    public String getDefaultTag() {
        return TAG;
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        for (RxPart part : this.parts) {
            part.toSax(handler, namespace, prefix, part.getDefaultTag());
        }
    }
}

