/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.builder;

import java.util.HashSet;
import java.util.List;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.IAction;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.builder.ActionArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.ArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisitesBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.AttributeAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.Group;
import org.eclipse.buckminster.core.cspec.model.PrerequisiteAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.UpToDatePolicy;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionBuilder
extends TopLevelAttributeBuilder
implements IAction {
    private String actorName;
    private final ExpandingProperties<String> actorProperties = new ExpandingProperties();
    private boolean always = false;
    private boolean assignConsoleSupport = true;
    private final PrerequisitesBuilder prerequisitesBuilder;
    private String productAlias;
    private IPath productBase;
    private int productFileCount = -1;
    private final HashSet<IPath> productPaths = new HashSet();
    private final ExpandingProperties<String> properties = new ExpandingProperties();
    private UpToDatePolicy upToDatePolicy = UpToDatePolicy.DEFAULT;

    ActionBuilder(CSpecBuilder cspecBuilder) {
        super(cspecBuilder);
        this.prerequisitesBuilder = new PrerequisitesBuilder(cspecBuilder);
    }

    public void addActorProperty(String key, String propVal, boolean mutable) {
        this.actorProperties.put(key, propVal, mutable);
    }

    @Override
    public void addPrerequisite(PrerequisiteBuilder prerequisite) throws PrerequisiteAlreadyDefinedException {
        this.prerequisitesBuilder.addPrerequisite(prerequisite);
    }

    public ActionArtifactBuilder addProductArtifact(String name, boolean publ, IPath output) throws AttributeAlreadyDefinedException {
        CSpecBuilder cspecBuilder = this.getCSpecBuilder();
        ActionArtifactBuilder bld = cspecBuilder.createActionArtifactBuilder();
        bld.setActionName(this.getName());
        bld.setName(name);
        bld.setPublic(publ);
        bld.setBase(output);
        cspecBuilder.addAttribute(bld);
        return bld;
    }

    public void addProductPath(IPath path) {
        this.productPaths.add(path);
    }

    public void addProperty(String key, String propVal, boolean mutable) {
        this.properties.put(key, propVal, mutable);
    }

    @Override
    public void clear() {
        super.clear();
        this.actorName = null;
        this.always = false;
        this.assignConsoleSupport = true;
        this.actorProperties.clear();
        this.prerequisitesBuilder.clear();
        this.productPaths.clear();
        this.properties.clear();
        this.productAlias = null;
        this.productBase = null;
        this.upToDatePolicy = UpToDatePolicy.DEFAULT;
        this.productFileCount = -1;
    }

    @Override
    public Action createAttribute() {
        return new Action(this);
    }

    @Override
    public String getActorName() {
        return this.actorName;
    }

    public ExpandingProperties<String> getActorProperties() {
        return this.actorProperties;
    }

    @Override
    public AttributeBuilder getAttributeBuilder(CSpecBuilder specBuilder) {
        return specBuilder == this.getCSpecBuilder() ? this : new ActionBuilder(specBuilder);
    }

    public PrerequisiteBuilder getPrerequisite(String prerequisteName) {
        return this.prerequisitesBuilder.getPrerequisite(prerequisteName);
    }

    @Override
    public Group getPrerequisiteGroup() {
        return null;
    }

    @Override
    public List<? extends IPrerequisite> getPrerequisites() {
        return this.getPrerequisitesBuilder().getPrerequisites();
    }

    public String getPrerequisitesAlias() {
        return this.prerequisitesBuilder.getName();
    }

    public PrerequisitesBuilder getPrerequisitesBuilder() {
        return this.prerequisitesBuilder;
    }

    @Override
    public String getProductAlias() {
        return this.productAlias;
    }

    public ArtifactBuilder getProductArtifact(String name) {
        ArtifactBuilder bld = this.getCSpecBuilder().getArtifactBuilder(name);
        return bld instanceof ActionArtifactBuilder ? bld : null;
    }

    @Override
    public IPath getProductBase() {
        return this.productBase;
    }

    @Override
    public int getProductFileCount() {
        return this.productFileCount;
    }

    public HashSet<IPath> getProductPaths() {
        return this.productPaths;
    }

    public ExpandingProperties<String> getProperties() {
        return this.properties;
    }

    @Override
    public UpToDatePolicy getUpToDatePolicy() {
        return this.upToDatePolicy;
    }

    @Override
    public void initFrom(IAttribute attribute) {
        IAction action = (IAction)attribute;
        super.initFrom(action);
        this.actorName = action.getActorName();
        this.actorProperties.putAll(action.getActorProperties(), true);
        this.always = action.isAlways();
        this.assignConsoleSupport = action.isAssignConsoleSupport();
        this.prerequisitesBuilder.initFrom(action.getPrerequisiteGroup());
        this.productAlias = action.getProductAlias();
        this.productBase = action.getProductBase();
        this.upToDatePolicy = action.getUpToDatePolicy();
        this.productFileCount = action.getProductFileCount();
        this.productPaths.addAll(action.getProductPaths());
        this.properties.putAll(action.getProperties(), true);
    }

    @Override
    public boolean isAlways() {
        return this.always;
    }

    @Override
    public boolean isAssignConsoleSupport() {
        return this.assignConsoleSupport;
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public void removePrerequisite(String prerequisteName) {
        this.prerequisitesBuilder.removePrerequisite(prerequisteName);
    }

    public void removeProductPath(IPath path) {
        this.productPaths.remove(path);
    }

    public void setActorName(String actorName) {
        this.actorName = actorName;
    }

    public void setAlways(boolean always) {
        this.always = always;
    }

    public void setAssignConsoleSupport(boolean assignConsoleSupport) {
        this.assignConsoleSupport = assignConsoleSupport;
    }

    public void setPrerequisites(Group prerequisites) {
        this.prerequisitesBuilder.initFrom(prerequisites);
    }

    public void setPrerequisitesAlias(String alias) {
        this.prerequisitesBuilder.setName(alias);
    }

    public void setPrerequisitesRebase(IPath rebase) {
        this.prerequisitesBuilder.setPrerequisiteRebase(rebase);
    }

    public void setProductAlias(String productAlias) {
        this.productAlias = productAlias;
    }

    public void setProductBase(IPath productBase) {
        this.productBase = productBase == null ? null : productBase.addTrailingSeparator();
    }

    public void setProductFileCount(int productFileCount) {
        this.productFileCount = productFileCount;
    }

    public void setUpToDatePolicy(UpToDatePolicy upToDatePolicy) {
        this.upToDatePolicy = upToDatePolicy;
    }
}

