/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.buckminster.core.cspec.IArtifact;
import org.eclipse.buckminster.core.cspec.IAttributeFilter;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.cspec.SaxablePath;
import org.eclipse.buckminster.core.cspec.builder.ArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.TopLevelAttribute;
import org.eclipse.buckminster.core.internal.actor.PerformManager;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Artifact
extends TopLevelAttribute
implements IArtifact {
    public static final String ATTR_PATH = "path";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_BASE = "base";
    private final IPath base;
    private final Set<IPath> paths;

    public Artifact(ArtifactBuilder builder) {
        super(builder);
        IPath b = builder.getBase();
        if (b != null && !b.hasTrailingSeparator()) {
            b = b.addTrailingSeparator();
        }
        this.base = b;
        this.paths = CSpec.createUnmodifiablePaths(builder.getPaths());
    }

    @Override
    public IPath getBase() {
        return this.base;
    }

    @Override
    public Set<IPath> getPaths() {
        return this.paths;
    }

    @Override
    protected void addAttributes(AttributesImpl attrs) {
        super.addAttributes(attrs);
        if (this.paths.size() == 1) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_PATH, (String)this.paths.iterator().next().toPortableString());
        }
        if (this.base != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_BASE, (String)this.base.toPortableString());
        }
    }

    @Override
    protected AttributeBuilder createAttributeBuilder(CSpecBuilder cspecBuilder) {
        return cspecBuilder.createArtifactBuilder();
    }

    @Override
    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        super.emitElements(handler, namespace, prefix);
        if (this.paths.size() > 1) {
            for (IPath path : this.paths) {
                SaxablePath sPath = (SaxablePath)path;
                sPath.toSax(handler, namespace, prefix, sPath.getDefaultTag());
            }
        }
    }

    protected IPath getExpandedBase(Map<String, ? extends Object> local) throws CoreException {
        if (this.base == null) {
            return this.getCSpec().getComponentLocation();
        }
        IPath expBase = PerformManager.expandPath(local, this.base);
        return expBase.isAbsolute() ? expBase : this.getCSpec().getComponentLocation().append(expBase);
    }

    @Override
    protected PathGroup[] internalGetPathGroups(IModelCache ctx, Map<String, ? extends Object> local, Stack<IAttributeFilter> filters) throws CoreException {
        IPath[] pathArr;
        int idx = this.paths.size();
        if (idx > 0) {
            pathArr = this.paths.toArray(new IPath[idx]);
            while (--idx >= 0) {
                pathArr[idx] = PerformManager.expandPath(local, pathArr[idx]);
            }
        } else {
            pathArr = Trivial.EMPTY_PATH_ARRAY;
        }
        return new PathGroup[]{new PathGroup(this.getExpandedBase(local), pathArr)};
    }
}

