/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.UUID;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.cspec.IAction;
import org.eclipse.buckminster.core.cspec.IActionArtifact;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.IAttributeFilter;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.IGenerator;
import org.eclipse.buckminster.core.cspec.IGroup;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.SaxablePath;
import org.eclipse.buckminster.core.cspec.WellknownActions;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.builder.GeneratorBuilder;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.ActionArtifact;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CircularReferenceException;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.cspec.model.Generator;
import org.eclipse.buckminster.core.cspec.model.MissingAttributeException;
import org.eclipse.buckminster.core.cspec.model.MissingDependencyException;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.cspec.model.TopLevelAttribute;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.metadata.ModelCache;
import org.eclipse.buckminster.core.metadata.ReferentialIntegrityException;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.core.metadata.model.IUUIDPersisted;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.UUIDKeyed;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSpec
extends UUIDKeyed
implements IUUIDPersisted,
ICSpecData {
    public static final String ATTR_FILTER = "filter";
    public static final String ATTR_PROJECT_INFO = "projectInfo";
    public static final String ATTR_SHORT_DESC = "shortDesc";
    public static final String ELEM_ACTIONS = "actions";
    public static final String ELEM_ARTIFACTS = "artifacts";
    public static final String ELEM_DEPENDENCIES = "dependencies";
    public static final String ELEM_GENERATORS = "generators";
    public static final String ELEM_DEPENDENCY = "dependency";
    public static final String ELEM_GROUPS = "groups";
    public static final String SELF_ARTIFACT = "buckminster.component.self";
    public static final String TAG = "cspec";
    public static final String COMPONENT_NAME_TYPE_SEPARATOR = "/!@@!/";
    public static final int SEQUENCE_NUMBER = 4;
    private static final Comparator<Attribute> attributeSorter = new Comparator<Attribute>(){

        @Override
        public int compare(Attribute o1, Attribute o2) {
            if (o1.isPublic() == o2.isPublic()) {
                return o1.getName().compareTo(o2.getName());
            }
            return o1.isPublic() ? -1 : 1;
        }
    };
    private final Map<String, Attribute> attributes;
    private final ComponentIdentifier componentIdentifier;
    private final List<ComponentRequest> dependencies;
    private final Map<ComponentIdentifier, Generator> generators;
    private final Documentation documentation;
    private final String shortDesc;
    private final Attribute selfAttribute;
    private final Filter filter;
    private final URL projectInfo;

    public static Set<IPath> createUnmodifiablePaths(Set<IPath> aSet) {
        if (aSet == null || aSet.size() == 0) {
            aSet = Collections.emptySet();
        } else {
            HashSet<SaxablePath> saxablePaths = new HashSet<SaxablePath>();
            for (IPath path : aSet) {
                saxablePaths.add(SaxablePath.coerce(path));
            }
            aSet = Collections.unmodifiableSet(saxablePaths);
        }
        return aSet;
    }

    public static String getTagInfo(ComponentIdentifier ci, URL projectInfoURL, String parentInfo) {
        StringBuilder bld = new StringBuilder();
        if (projectInfoURL != null) {
            bld.append("project: ");
            bld.append(projectInfoURL);
            bld.append(", ");
        }
        if (parentInfo != null) {
            int pathIdx = parentInfo.indexOf("path: ");
            if (projectInfoURL == null) {
                bld.append(parentInfo);
            } else if (pathIdx >= 0) {
                bld.append(parentInfo, pathIdx, parentInfo.length());
            }
            if (pathIdx >= 0) {
                bld.append(" -> ");
            } else {
                bld.append(", path: ");
            }
        } else {
            bld.append("path: ");
        }
        ci.toString(bld);
        return bld.toString();
    }

    public CSpec(CSpecBuilder cspecBld) {
        int top;
        cspecBld.finalWrapUp();
        this.componentIdentifier = cspecBld.getComponentIdentifier();
        this.projectInfo = cspecBld.getProjectInfo();
        this.documentation = cspecBld.getDocumentation();
        this.shortDesc = cspecBld.getShortDesc();
        this.filter = cspecBld.getFilter();
        this.selfAttribute = new TopLevelAttribute(SELF_ARTIFACT){

            @Override
            protected AttributeBuilder createAttributeBuilder(CSpecBuilder cspecBuilder) {
                return null;
            }

            @Override
            protected PathGroup[] internalGetPathGroups(IModelCache ctx, Map<String, ? extends Object> local, Stack<IAttributeFilter> filters) throws CoreException {
                IPath me = CSpec.this.getComponentLocation();
                PathGroup meGroup = me.hasTrailingSeparator() ? new PathGroup(me, Trivial.EMPTY_PATH_ARRAY) : new PathGroup(me.removeLastSegments(1).addTrailingSeparator(), new IPath[]{new Path(me.lastSegment())});
                return new PathGroup[]{meGroup};
            }
        };
        this.selfAttribute.setCSPec(this);
        Map<String, AttributeBuilder> attrs = cspecBld.getAttributes();
        int n = top = attrs == null ? 0 : attrs.size();
        if (top == 0) {
            this.attributes = Collections.emptyMap();
        } else {
            Map<Object, Object> map;
            Collection<AttributeBuilder> values = attrs.values();
            if (top == 1) {
                Attribute attr = values.iterator().next().createAttribute();
                attr.setCSPec(this);
                map = Collections.singletonMap(attr.getName(), attr);
            } else {
                map = new HashMap(top);
                for (AttributeBuilder bld : values) {
                    Attribute attr = bld.createAttribute();
                    attr.setCSPec(this);
                    map.put(attr.getName(), attr);
                }
            }
            this.attributes = Collections.unmodifiableMap(map);
        }
        List<ComponentRequestBuilder> deps = cspecBld.getDependencyBuilders();
        int n2 = top = deps == null ? 0 : deps.size();
        if (top == 0) {
            this.dependencies = Collections.emptyList();
        } else if (top == 1) {
            this.dependencies = Collections.singletonList(deps.get(0).createComponentRequest());
        } else {
            ArrayList<ComponentRequest> list = new ArrayList<ComponentRequest>();
            for (ComponentRequestBuilder dep : deps) {
                list.add(dep.createComponentRequest());
            }
            this.dependencies = Collections.unmodifiableList(list);
        }
        Collection<GeneratorBuilder> gens = cspecBld.getGeneratorList();
        top = gens.size();
        if (top == 0) {
            this.generators = Collections.emptyMap();
        } else {
            Map<Object, Object> map;
            if (top == 1) {
                GeneratorBuilder bld = gens.iterator().next();
                Generator gen = bld.createGenerator(this);
                map = Collections.singletonMap(bld.getGeneratedIdentifier(), gen);
            } else {
                map = new TreeMap();
                for (GeneratorBuilder bld : gens) {
                    Generator gen = bld.createGenerator(this);
                    map.put(bld.getGeneratedIdentifier(), gen);
                }
            }
            this.generators = Collections.unmodifiableMap(map);
        }
    }

    @Override
    public Attribute getAttribute(String name) {
        Attribute attr = this.attributes.get(name);
        if (attr == null && name.equals(SELF_ARTIFACT)) {
            attr = this.selfAttribute;
        }
        return attr;
    }

    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    public Attribute[] getAttributes(Collection<String> attributeNames) throws MissingAttributeException {
        int sz = attributeNames == null ? 0 : attributeNames.size();
        Attribute[] attrs = new Attribute[sz];
        int idx = 0;
        for (String str : attributeNames) {
            attrs[idx++] = this.getRequiredAttribute(str);
        }
        return attrs;
    }

    public Attribute[] getAttributes(String ... attributeNames) throws MissingAttributeException {
        return this.getAttributes(Arrays.asList(attributeNames));
    }

    public List<Attribute> getAttributesProducedByActions(boolean includePrivate) throws CoreException {
        ModelCache ctx = new ModelCache();
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        for (Attribute ag : this.attributes.values()) {
            if (!includePrivate && !ag.isPublic() || !ag.isProducedByActions(ctx)) continue;
            attrs.add(ag);
        }
        return attrs;
    }

    public Attribute getBindEntryPoint() {
        return this.getAttribute(WellknownActions.BUCKMINSTER.BIND_ENTRYPOINT.toString());
    }

    @Override
    public ComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    public IPath getComponentLocation() throws CoreException {
        return WorkspaceInfo.getComponentLocation(this);
    }

    @Override
    public String getComponentTypeID() {
        return this.componentIdentifier.getComponentTypeID();
    }

    public String getDefaultTag() {
        return TAG;
    }

    public Collection<ComponentRequest> getDependencies() {
        return this.dependencies;
    }

    @Override
    @Deprecated
    public ComponentRequest getDependency(String depName, String depType) throws MissingDependencyException {
        return this.getDependency(depName, depType, null);
    }

    @Override
    public ComponentRequest getDependency(String depName, String depType, VersionRange depRange) throws MissingDependencyException {
        int idx = this.dependencies.size();
        while (--idx >= 0) {
            ComponentRequest dependency = this.dependencies.get(idx);
            if (!depName.equals(dependency.getName()) || depType != null && dependency.getComponentTypeID() != null && !depType.equals(dependency.getComponentTypeID()) || depRange != null && dependency.getVersionRange() != null && dependency.getVersionRange().intersect(depRange) == null) continue;
            return dependency;
        }
        throw new MissingDependencyException(this.componentIdentifier.toString(), depName);
    }

    @Override
    public Documentation getDocumentation() {
        return this.documentation;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    public Collection<Generator> getGeneratorList() {
        return this.generators.values();
    }

    @Override
    public String getName() {
        return this.componentIdentifier.getName();
    }

    public Attribute getPrebind() {
        return this.getAttribute(WellknownActions.BUCKMINSTER.PREBIND.toString());
    }

    @Override
    public URL getProjectInfo() {
        return this.projectInfo;
    }

    public List<QualifiedDependency> getQualifiedDependencies(boolean attributePrune) throws CoreException {
        HashMap<ComponentRequest, Set<String>> deps = new HashMap<ComponentRequest, Set<String>>();
        if (!attributePrune) {
            for (ComponentRequest componentRequest : this.getDependencies()) {
                deps.put(componentRequest, new HashSet());
            }
        }
        for (IAttribute iAttribute : this.getAttributes().values()) {
            this.addDependencyBundle(deps, iAttribute);
        }
        if (!this.generators.isEmpty()) {
            for (IGenerator iGenerator : this.generators.values()) {
                String component = iGenerator.getComponent();
                if (component == null) {
                    this.addDependencyBundle(deps, this.getRequiredAttribute(iGenerator.getAttribute()));
                    continue;
                }
                ComponentRequest dep = this.getDependency(component, null, null);
                HashSet<String> attrs = (HashSet<String>)deps.get(dep);
                if (attrs == null) {
                    attrs = new HashSet<String>();
                    deps.put(dep, attrs);
                }
                attrs.add(iGenerator.getAttribute());
            }
        }
        ArrayList<QualifiedDependency> arrayList = new ArrayList<QualifiedDependency>(deps.size());
        for (Map.Entry entry : deps.entrySet()) {
            arrayList.add(new QualifiedDependency((ComponentRequest)entry.getKey(), (Collection)entry.getValue()));
        }
        return arrayList;
    }

    public Attribute getReferencedAttribute(String componentName, String componentType, VersionRange versionRange, String attributeName, IModelCache ctx) throws CoreException {
        CSpec referencedCSpec = this.getReferencedCSpec(componentName, componentType, versionRange, ctx);
        if (referencedCSpec == null) {
            return null;
        }
        Attribute referencedAttr = referencedCSpec.getRequiredAttribute(attributeName);
        if (referencedAttr.isEnabled(ctx)) {
            if (referencedCSpec == this || referencedAttr.isPublic()) {
                return referencedAttr;
            }
            throw new MissingAttributeException(referencedCSpec.getComponentIdentifier().toString(), attributeName, true);
        }
        return null;
    }

    public CSpec getReferencedCSpec(String componentName, String componentType, VersionRange versionRange, IModelCache ctx) throws CoreException {
        if (componentName == null) {
            return this;
        }
        ComponentRequest dep = this.getDependency(componentName, componentType, versionRange);
        if (!dep.isEnabled(ctx.getProperties())) {
            return null;
        }
        try {
            return ctx.findCSpec(this, dep);
        }
        catch (MissingComponentException e) {
            if (dep.isOptional()) {
                return null;
            }
            throw e;
        }
    }

    public Attribute getRequiredAttribute(String name) throws MissingAttributeException {
        Attribute attr = this.getAttribute(name);
        if (attr == null) {
            throw new MissingAttributeException(this.componentIdentifier.toString(), name);
        }
        return attr;
    }

    @Override
    public String getShortDesc() {
        return this.shortDesc;
    }

    public String getTagInfo(String parentInfo) {
        return CSpec.getTagInfo(this.componentIdentifier, this.projectInfo, parentInfo);
    }

    @Override
    public Version getVersion() {
        return this.componentIdentifier.getVersion();
    }

    @Override
    public boolean isPersisted(StorageManager sm) throws CoreException {
        return sm.getCSpecs().contains(this);
    }

    public boolean isPruneApplicable(RMContext context, Map<String, ? extends Object> properties, boolean pruneForAttributes, Set<String> attrNames) throws CoreException {
        Collection<ComponentRequest> deps = this.getDependencies();
        for (ComponentRequest dep : deps) {
            Filter depFilter = dep.getFilter();
            if (depFilter == null) continue;
            depFilter.addConsultedAttributes(context.getFilterAttributeUsageMap());
            if (depFilter.matchCase(properties)) continue;
            return true;
        }
        Set<String> allAttrNames = this.getAttributes().keySet();
        if (pruneForAttributes) {
            if (attrNames.isEmpty()) {
                attrNames = allAttrNames;
            }
        } else {
            attrNames = allAttrNames;
        }
        HashSet<String> referencedAttrNames = new HashSet<String>();
        for (String attrName : attrNames) {
            Attribute attr = this.getAttribute(attrName);
            if (attr == null) continue;
            this.addReferencedDependencies(null, referencedAttrNames, attr, null);
        }
        return !allAttrNames.equals(referencedAttrNames);
    }

    public CSpec prune(RMContext context, Map<String, ? extends Object> properties, boolean pruneForAttributes, Set<String> attrNames) throws CoreException {
        Collection<ComponentRequest> deps;
        if (!this.isPruneApplicable(context, properties, pruneForAttributes, attrNames)) {
            return this;
        }
        CSpecBuilder bld = new CSpecBuilder();
        bld.setComponentTypeID(this.getComponentTypeID());
        bld.setDocumentation(this.getDocumentation());
        bld.setName(this.getName());
        bld.setProjectInfo(this.getProjectInfo());
        bld.setShortDesc(this.getShortDesc());
        bld.setVersion(this.getVersion());
        bld.setFilter(this.getFilter());
        Set<String> allAttrNames = this.getAttributes().keySet();
        if (pruneForAttributes) {
            if (attrNames.isEmpty()) {
                attrNames = allAttrNames;
            }
        } else {
            attrNames = allAttrNames;
        }
        if (!pruneForAttributes || attrNames.isEmpty() && this.getGeneratorList().isEmpty()) {
            deps = this.getDependencies();
        } else {
            HashSet<ComponentRequest> hashSet = new HashSet<ComponentRequest>();
            HashSet<String> referencedAttrs = new HashSet<String>();
            for (String string : attrNames) {
                Attribute attr = this.getAttribute(string);
                if (attr == null) continue;
                this.addReferencedDependencies(hashSet, referencedAttrs, attr, null);
            }
            for (IGenerator iGenerator : this.getGeneratorList()) {
                String component = iGenerator.getComponent();
                if (component == null) {
                    this.addReferencedDependencies(hashSet, referencedAttrs, this.getRequiredAttribute(iGenerator.getAttribute()), null);
                    continue;
                }
                hashSet.add(this.getDependency(component, null, null));
            }
            deps = hashSet;
        }
        for (ComponentRequest componentRequest : deps) {
            Filter filter = componentRequest.getFilter();
            if (filter != null) {
                filter.addConsultedAttributes(context.getFilterAttributeUsageMap());
                if (!filter.matchCase(properties)) continue;
            }
            bld.addDependency(componentRequest);
        }
        for (String string : attrNames) {
            Attribute attribute = this.getAttribute(string);
            if (attribute == null || !this.dependenciesFulfilled(attribute, bld, null)) continue;
            bld.addAttribute(attribute);
        }
        for (IGenerator iGenerator : this.getGeneratorList()) {
            String string = iGenerator.getComponent();
            if (string == null ? bld.getAttribute(iGenerator.getAttribute()) == null : bld.getDependency(string, null, null) == null) continue;
            bld.addGenerator(iGenerator);
        }
        return bld.createCSpec();
    }

    @Override
    public void remove(StorageManager sm) throws CoreException {
        UUID thisId = this.getId();
        if (!sm.getResolutions().getReferencingKeys(thisId, "cspecId").isEmpty()) {
            throw new ReferentialIntegrityException(this, "remove", Messages.Referenced_from_Resolution);
        }
        sm.getCSpecs().removeElement(thisId);
    }

    @Override
    public void store(StorageManager sm) throws CoreException {
        sm.getCSpecs().putElement(this);
    }

    public void toSax(ContentHandler receiver) throws SAXException {
        receiver.startDocument();
        this.toSax(receiver, "http://www.eclipse.org/buckminster/CSpec-1.0", "cs", this.getDefaultTag());
        receiver.endDocument();
    }

    public void verifyConsistency() throws MissingDependencyException, MissingAttributeException, CircularReferenceException {
        for (Attribute attribute : this.attributes.values()) {
            if (attribute instanceof IActionArtifact) continue;
            this.verifyPrerequisites(attribute, null);
        }
        for (IGenerator iGenerator : this.generators.values()) {
            String component = iGenerator.getComponent();
            if (component == null) {
                this.getRequiredAttribute(iGenerator.getAttribute());
                continue;
            }
            this.getDependency(component, null, null);
        }
    }

    protected void addAttributes(AttributesImpl attrs) {
        Version version;
        Utils.addAttribute((AttributesImpl)attrs, (String)"name", (String)this.componentIdentifier.getName());
        String ctypeID = this.componentIdentifier.getComponentTypeID();
        if (ctypeID != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"componentType", (String)ctypeID);
        }
        if ((version = this.componentIdentifier.getVersion()) != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"version", (String)version.toString());
        }
        if (this.projectInfo != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_PROJECT_INFO, (String)this.projectInfo.toString());
        }
        if (this.shortDesc != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_SHORT_DESC, (String)this.shortDesc);
        }
        if (this.filter != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_FILTER, (String)this.filter.toString());
        }
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        if (this.documentation != null) {
            this.documentation.toSax(handler, namespace, prefix, this.documentation.getDefaultTag());
        }
        Utils.emitCollection((String)namespace, (String)prefix, (String)ELEM_DEPENDENCIES, (String)ELEM_DEPENDENCY, this.dependencies, (ContentHandler)handler);
        Utils.emitCollection((String)namespace, (String)prefix, (String)ELEM_GENERATORS, (String)"generator", this.generators.values(), (ContentHandler)handler);
        ArrayList<Attribute> topArtifacts = new ArrayList<Attribute>();
        ArrayList<Attribute> actions = new ArrayList<Attribute>();
        ArrayList<Attribute> groups = new ArrayList<Attribute>();
        for (Attribute attr : this.attributes.values()) {
            if (attr instanceof IAction) {
                actions.add(attr);
                continue;
            }
            if (attr instanceof IGroup) {
                groups.add(attr);
                continue;
            }
            if (attr instanceof IActionArtifact) continue;
            topArtifacts.add(attr);
        }
        Collections.sort(topArtifacts, attributeSorter);
        Collections.sort(actions, attributeSorter);
        Collections.sort(groups, attributeSorter);
        Utils.emitCollection((String)namespace, (String)prefix, (String)ELEM_ARTIFACTS, null, topArtifacts, (ContentHandler)handler);
        Utils.emitCollection((String)namespace, (String)prefix, (String)ELEM_ACTIONS, null, actions, (ContentHandler)handler);
        Utils.emitCollection((String)namespace, (String)prefix, (String)ELEM_GROUPS, null, groups, (ContentHandler)handler);
    }

    protected String getElementNamespace(String namespace) {
        return "http://www.eclipse.org/buckminster/CSpec-1.0";
    }

    protected String getElementPrefix(String prefix) {
        return "cs";
    }

    List<ActionArtifact> getActionArtifacts(Action action) {
        List<ActionArtifact> artifacts = null;
        String actionName = action.getName();
        for (IAttribute iAttribute : this.attributes.values()) {
            ActionArtifact aa;
            if (!(iAttribute instanceof IActionArtifact) || !(aa = (ActionArtifact)iAttribute).getActionName().equals(actionName)) continue;
            if (artifacts == null) {
                artifacts = new ArrayList<ActionArtifact>();
            }
            artifacts.add(aa);
        }
        if (artifacts == null) {
            artifacts = Collections.emptyList();
        }
        return artifacts;
    }

    private void addDependencyBundle(Map<ComponentRequest, Set<String>> deps, IAttribute dp) throws CoreException {
        for (IPrerequisite iPrerequisite : dp.getPrerequisites()) {
            if (iPrerequisite.isExternal()) {
                ComponentRequest rq = this.getDependency(iPrerequisite.getComponentName(), iPrerequisite.getComponentType(), iPrerequisite.getVersionRange());
                Set<String> attrs = deps.get(rq);
                if (attrs == null) {
                    attrs = new HashSet<String>();
                    deps.put(rq, attrs);
                }
                attrs.add(iPrerequisite.getAttribute());
                continue;
            }
            Attribute localGroup = this.getAttribute(iPrerequisite.getAttribute());
            if (localGroup instanceof IActionArtifact) {
                localGroup = ((ActionArtifact)localGroup).getAction();
            }
            this.addDependencyBundle(deps, localGroup);
        }
    }

    private void addReferencedDependencies(Set<ComponentRequest> deps, Set<String> attrNames, Attribute attr, Stack<IAttributeFilter> filters) throws CoreException {
        if (attrNames.contains(attr.getName())) {
            return;
        }
        attrNames.add(attr.getName());
        if (attr instanceof IActionArtifact) {
            this.addReferencedDependencies(deps, attrNames, ((ActionArtifact)attr).getAction(), filters);
            return;
        }
        for (Prerequisite prereq : attr.getPrerequisites(filters)) {
            if (prereq.isExternal()) {
                if (deps == null) continue;
                deps.add(this.getDependency(prereq.getComponentName(), prereq.getComponentType(), prereq.getVersionRange()));
                continue;
            }
            Attribute localAttr = this.getRequiredAttribute(prereq.getAttribute());
            if (prereq.isPatternFilter()) {
                if (filters == null) {
                    filters = new Stack();
                }
                filters.push(prereq);
                this.addReferencedDependencies(deps, attrNames, localAttr, filters);
                filters.pop();
                continue;
            }
            this.addReferencedDependencies(deps, attrNames, localAttr, filters);
        }
    }

    private boolean dependenciesFulfilled(Attribute attr, CSpecBuilder bld, Stack<IAttributeFilter> filters) throws CoreException {
        if (attr instanceof IActionArtifact) {
            attr = ((ActionArtifact)attr).getAction();
        }
        for (Prerequisite pq : attr.getPrerequisites(filters)) {
            if (pq.isExternal()) {
                if (bld.getDependency(pq.getComponentName(), pq.getComponentType(), pq.getVersionRange()) != null) continue;
                return false;
            }
            if (pq.isPatternFilter()) {
                if (filters == null) {
                    filters = new Stack();
                }
                filters.push(pq);
            }
            if (!this.dependenciesFulfilled(this.getRequiredAttribute(pq.getAttribute()), bld, filters)) {
                return false;
            }
            if (!pq.isPatternFilter()) continue;
            filters.pop();
        }
        return true;
    }

    private void verifyNonCircularDependency(Stack<String> seenAttributes, Collection<Prerequisite> prereqs, Stack<IAttributeFilter> filters) throws MissingAttributeException, CircularReferenceException {
        for (Prerequisite prereq : prereqs) {
            List<Prerequisite> agPreqs;
            if (prereq.isExternal()) continue;
            Attribute ag = this.getRequiredAttribute(prereq.getAttribute());
            if (ag instanceof IActionArtifact) {
                ag = ((ActionArtifact)ag).getAction();
            }
            if (seenAttributes.contains(ag.getName())) {
                throw new CircularReferenceException(this.getComponentIdentifier().toString(), seenAttributes, ag.getName());
            }
            if (prereq.isPatternFilter()) {
                if (filters == null) {
                    filters = new Stack();
                }
                filters.push(prereq);
                agPreqs = ag.getPrerequisites(filters);
                filters.pop();
            } else {
                agPreqs = ag.getPrerequisites(filters);
            }
            if (agPreqs.size() <= 0) continue;
            seenAttributes.push(ag.getName());
            this.verifyNonCircularDependency(seenAttributes, agPreqs, filters);
            seenAttributes.pop();
        }
    }

    private void verifyPrerequisites(Attribute attr, Stack<IAttributeFilter> filters) throws MissingDependencyException, MissingAttributeException, CircularReferenceException {
        Stack<String> seenActions = new Stack<String>();
        for (Prerequisite prereq : attr.getPrerequisites(filters)) {
            List<Prerequisite> agPreqs;
            if (prereq.isExternal()) {
                this.getDependency(prereq.getComponentName(), prereq.getComponentType(), prereq.getVersionRange());
                continue;
            }
            Attribute ag = this.getRequiredAttribute(prereq.getAttribute());
            if (ag instanceof IActionArtifact) {
                ((ActionArtifact)ag).getAction();
            }
            if (prereq.isPatternFilter()) {
                if (filters == null) {
                    filters = new Stack();
                }
                filters.push(prereq);
            }
            if ((agPreqs = ag.getPrerequisites(filters)).size() > 0) {
                seenActions.clear();
                seenActions.push(ag.getName());
                this.verifyNonCircularDependency(seenActions, agPreqs, filters);
            }
            if (!prereq.isPatternFilter()) continue;
            filters.pop();
        }
    }
}

