/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.buckminster.core.actor.IGlobalContext;
import org.eclipse.buckminster.core.common.model.Format;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IGenerator;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.cspec.model.NamedElement;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.query.builder.ComponentQueryBuilder;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.rmap.model.Locator;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.ResourceMap;
import org.eclipse.buckminster.core.rmap.model.SearchPath;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.p2.metadata.Version;
import org.xml.sax.helpers.AttributesImpl;

public class Generator
extends NamedElement
implements IGenerator {
    public static final String ATTR_ATTRIBUTE = "attribute";
    public static final String ATTR_COMPONENT = "component";
    public static final String ATTR_GENERATES = "generates";
    public static final String ATTR_GENERATES_TYPE = "generatesType";
    public static final String ATTR_GENERATES_VERSION = "generatesVersion";
    public static final String TAG = "generator";
    private final CSpec cspec;
    private final String attribute;
    private final String component;
    private final String generatesType;
    private final Version generatesVersion;

    public Generator(CSpec cspec, String component, String attribute, ComponentIdentifier generates) {
        super(generates);
        this.cspec = cspec;
        this.component = component;
        this.attribute = attribute;
        this.generatesType = generates.getComponentTypeID();
        this.generatesVersion = generates.getVersion();
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getComponent() {
        return this.component;
    }

    public CSpec getCSpec() {
        return this.cspec;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public IComponentIdentifier getGeneratedIdentifier() {
        return new ComponentIdentifier(this.getName(), this.generatesType, this.generatesVersion);
    }

    public String getGenerates() {
        return this.getName();
    }

    public String getNameAttributeName() {
        return ATTR_GENERATES;
    }

    public void registerGeneratedResolution(PathGroup[] result, IGlobalContext ctx, IProgressMonitor monitor) throws CoreException {
        Format uri;
        IPath componentLocation;
        if (result.length != 1) {
            return;
        }
        PathGroup pg = result[0];
        HashMap<String, Long> fileNames = new HashMap<String, Long>();
        pg.appendRelativeFiles(fileNames);
        if (fileNames.isEmpty()) {
            return;
        }
        Set<String> paths = fileNames.keySet();
        String readerType = "local";
        boolean isFile = false;
        if (paths.size() == 1) {
            IPath path = Path.fromOSString((String)paths.iterator().next());
            String suffix = path.getFileExtension();
            if ("zip".equals(suffix) || "jar".equals(suffix)) {
                readerType = "url.zipped";
                isFile = true;
            }
            componentLocation = pg.getBase().append(path);
        } else {
            componentLocation = pg.getBase();
        }
        try {
            uri = new Format(URLUtils.normalizeToURL((String)componentLocation.toOSString()).toString());
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        IComponentIdentifier ci = this.getGeneratedIdentifier();
        String cType = ci.getComponentTypeID();
        ResourceMap rmap = new ResourceMap(null);
        SearchPath searchPath = new SearchPath(rmap, "default");
        HashMap<String, String> props = new HashMap<String, String>(2);
        props.put("buckminster.mutable", "false");
        props.put("buckminster.source", "false");
        Provider provider = new Provider(searchPath, readerType, new String[]{cType}, null, uri, null, null, null, props, null, null);
        searchPath.addProvider(provider);
        rmap.addSearchPath(searchPath);
        rmap.addMatcher(new Locator(rmap, null, "default"));
        ComponentQueryBuilder query = new ComponentQueryBuilder();
        query.setRootRequest(new ComponentRequest(ci.getName(), ci.getComponentTypeID(), null));
        ResolutionContext rctx = new ResolutionContext(query.createComponentQuery());
        BOMNode node = rmap.resolve(rctx.getRootNodeQuery(), monitor);
        Resolution res = node.getResolution();
        if (res != null) {
            if (isFile) {
                componentLocation = componentLocation.removeLastSegments(1);
            }
            ctx.addGeneratedResolution(res, componentLocation);
        }
    }

    protected void addAttributes(AttributesImpl attrs) {
        super.addAttributes(attrs);
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ATTRIBUTE, (String)this.attribute);
        if (this.component != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_COMPONENT, (String)this.component);
        }
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_GENERATES, (String)this.getName());
        if (this.generatesType != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_GENERATES_TYPE, (String)this.generatesType);
        }
        if (this.generatesVersion != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_GENERATES_VERSION, (String)this.generatesVersion.toString());
        }
    }
}

