/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.parser;

import org.eclipse.buckminster.core.common.parser.DocumentationHandler;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.parser.ActionsHandler;
import org.eclipse.buckminster.core.cspec.parser.ArtifactsHandler;
import org.eclipse.buckminster.core.cspec.parser.DependenciesHandler;
import org.eclipse.buckminster.core.cspec.parser.GeneratorsHandler;
import org.eclipse.buckminster.core.cspec.parser.GroupsHandler;
import org.eclipse.buckminster.core.cspec.parser.ICSpecBuilderSupport;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.eclipse.core.runtime.CoreException;
import org.osgi.framework.InvalidSyntaxException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CSpecHandler
extends ExtensionAwareHandler
implements ICSpecBuilderSupport,
ChildPoppedListener {
    public static final String TAG = "cspec";
    private DocumentationHandler documentationHandler;
    private DependenciesHandler dependenciesHandler;
    private GeneratorsHandler generatorsHandler;
    private ArtifactsHandler artifactsHandler;
    private ActionsHandler actionsHandler;
    private GroupsHandler groupsHandler;
    private CSpecBuilder builder;

    public CSpecHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) throws SAXException {
        if (child instanceof DocumentationHandler) {
            this.builder.setDocumentation(((DocumentationHandler)child).createDocumentation());
        }
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        ChildHandler ch;
        if ("documentation".equals(localName)) {
            if (this.documentationHandler == null) {
                this.documentationHandler = new DocumentationHandler((AbstractHandler)this);
            }
            ch = this.documentationHandler;
        } else if ("dependencies".equals(localName)) {
            if (this.dependenciesHandler == null) {
                this.dependenciesHandler = new DependenciesHandler((AbstractHandler)this);
            }
            ch = this.dependenciesHandler;
        } else if ("generators".equals(localName)) {
            if (this.generatorsHandler == null) {
                this.generatorsHandler = new GeneratorsHandler((AbstractHandler)this);
            }
            ch = this.generatorsHandler;
        } else if ("artifacts".equals(localName)) {
            if (this.artifactsHandler == null) {
                this.artifactsHandler = new ArtifactsHandler((AbstractHandler)this);
            }
            ch = this.artifactsHandler;
        } else if ("actions".equals(localName)) {
            if (this.actionsHandler == null) {
                this.actionsHandler = new ActionsHandler((AbstractHandler)this);
            }
            ch = this.actionsHandler;
        } else if ("groups".equals(localName)) {
            if (this.groupsHandler == null) {
                this.groupsHandler = new GroupsHandler((AbstractHandler)this);
            }
            ch = this.groupsHandler;
        } else {
            ch = super.createHandler(uri, localName, attrs);
        }
        return ch;
    }

    public final CSpec getCSpec() {
        return this.builder.createCSpec();
    }

    public final CSpecBuilder getCSpecBuilder() {
        return this.builder;
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        super.handleAttributes(attrs);
        this.builder = new CSpecBuilder();
        this.builder.setName(CSpecHandler.getOptionalStringValue((Attributes)attrs, (String)"name"));
        this.builder.setComponentTypeID(this.getComponentType(attrs));
        this.builder.setProjectInfo(this.getOptionalURLValue(attrs, "projectInfo"));
        this.builder.setShortDesc(CSpecHandler.getOptionalStringValue((Attributes)attrs, (String)"shortDesc"));
        try {
            this.builder.setVersion(VersionHelper.parseVersionAttributes(attrs));
        }
        catch (CoreException e) {
            throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
        }
        String filter = CSpecHandler.getOptionalStringValue((Attributes)attrs, (String)"filter");
        if (filter != null) {
            try {
                this.builder.setFilter(FilterFactory.newInstance((String)filter));
            }
            catch (InvalidSyntaxException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
            }
        }
    }
}

