/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.parser;

import org.eclipse.buckminster.core.cspec.builder.GeneratorBuilder;
import org.eclipse.buckminster.core.cspec.builder.NamedElementBuilder;
import org.eclipse.buckminster.core.cspec.parser.CSpecElementHandler;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class GeneratorHandler
extends CSpecElementHandler {
    public static final String TAG = "generator";

    GeneratorHandler(AbstractHandler parent) {
        super(parent);
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        super.handleAttributes(attrs);
        GeneratorBuilder builder = (GeneratorBuilder)this.getBuilder();
        builder.setComponent(GeneratorHandler.getOptionalStringValue((Attributes)attrs, (String)"component"));
        builder.setAttribute(this.getStringValue(attrs, "attribute"));
        builder.setGeneratesType(GeneratorHandler.getOptionalStringValue((Attributes)attrs, (String)"generatesType"));
        String version = GeneratorHandler.getOptionalStringValue((Attributes)attrs, (String)"generatesVersion");
        if (version != null) {
            try {
                builder.setGeneratesVersion(VersionHelper.parseVersion(version));
            }
            catch (IllegalArgumentException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
            }
        }
    }

    protected NamedElementBuilder createBuilder() {
        return this.getCSpecBuilder().createGeneratorBuilder();
    }

    protected String getNameAttribute(Attributes attrs) throws SAXException {
        return this.getStringValue(attrs, "generates");
    }
}

