/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.ctype;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.cspec.AbstractResolutionBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.ctype.MissingCSpecSourceException;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.ResolvedNode;
import org.eclipse.buckminster.core.parser.IParser;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IFileReader;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuckminsterCSpecBuilder
extends AbstractResolutionBuilder
implements IStreamConsumer<CSpec> {
    @Override
    public synchronized BOMNode build(IComponentReader[] readerHandle, boolean forResolutionAidOnly, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 2000);
        IComponentReader reader = readerHandle[0];
        try {
            CSpecBuilder cspecBld = new CSpecBuilder();
            if (reader instanceof ICatalogReader) {
                ICatalogReader catRdr = (ICatalogReader)reader;
                String fileName = BuckminsterCSpecBuilder.getMetadataFile(catRdr, IComponentType.PREF_CSPEC_FILE, "buckminster.cspec", MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
                cspecBld.initFrom(catRdr.readFile(fileName, this, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100)));
            } else {
                cspecBld.initFrom(((IFileReader)reader).readFile(this, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000)));
            }
            this.applyExtensions(cspecBld, forResolutionAidOnly, reader, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
            ResolvedNode resolvedNode = this.createNode(reader, cspecBld);
            return resolvedNode;
        }
        catch (FileNotFoundException e) {
            throw new MissingCSpecSourceException(reader.getProviderMatch());
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public CSpec consumeStream(IComponentReader reader, String streamName, InputStream stream, IProgressMonitor monitor) throws CoreException {
        IParser<CSpec> cspecParser = CorePlugin.getDefault().getParserFactory().getCSpecParser(true);
        return cspecParser.parse(streamName, stream);
    }
}

