/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.osgi.util.NLS;

public class CryptoUtils {
    private static String ENCODING_UTF8 = "UTF-8";

    public static String encrypt(byte[] bytes, String algorithmName) {
        String md5val = "";
        MessageDigest algorithm = null;
        try {
            algorithm = MessageDigest.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.Unknown_encrypt_algorithm_0, (Object)algorithmName));
        }
        algorithm.reset();
        algorithm.update(bytes);
        byte[] messageDigest = algorithm.digest();
        StringBuffer hexString = new StringBuffer();
        int i = 0;
        while (i < messageDigest.length) {
            String hex = Integer.toHexString(0xFF & messageDigest[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
            ++i;
        }
        md5val = hexString.toString();
        return md5val;
    }

    public static String encrypt(String input, String algorithmName) {
        return CryptoUtils.encrypt(input, ENCODING_UTF8, algorithmName);
    }

    public static String encrypt(String input, String encodingCharsetName, String algorithmName) {
        try {
            return CryptoUtils.encrypt(input.getBytes(encodingCharsetName), algorithmName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(NLS.bind((String)Messages.Internal_error_0_is_not_supported_encoding, (Object)ENCODING_UTF8), e);
        }
    }
}

