/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import org.eclipse.buckminster.core.helpers.ProgressStatistics;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProgressReporter
extends Thread {
    private final IProgressMonitor reporterMonitor;
    private final ProgressStatistics reporterProgress;
    private final String format;
    private final int timeout;
    private boolean running;

    public ProgressReporter(IProgressMonitor reporterMonitor, ProgressStatistics reporterProgress, String format, int timeout) {
        this.reporterMonitor = reporterMonitor;
        this.reporterProgress = reporterProgress;
        this.format = format;
        this.timeout = timeout;
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.running && !this.reporterMonitor.isCanceled()) {
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ProgressReporter progressReporter = this;
            synchronized (progressReporter) {
                if (this.running && this.reporterProgress.shouldReport()) {
                    this.reporterMonitor.subTask(String.format(this.format, this.reporterProgress.report()));
                }
            }
        }
    }

    public synchronized void stopReporting() {
        this.running = false;
        this.interrupt();
    }
}

