/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.util.Properties;
import org.eclipse.buckminster.core.helpers.SmartArrayList;

public class StringUtil {
    public static String escapeHTML(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(string.length());
        boolean lastWasBlankChar = false;
        int len = string.length();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (lastWasBlankChar) {
                    lastWasBlankChar = false;
                    sb.append("&nbsp;");
                } else {
                    lastWasBlankChar = true;
                    sb.append(' ');
                }
            } else {
                lastWasBlankChar = false;
                if (c == '\"') {
                    sb.append("&quot;");
                } else if (c == '&') {
                    sb.append("&amp;");
                } else if (c == '<') {
                    sb.append("&lt;");
                } else if (c == '>') {
                    sb.append("&gt;");
                } else if (c == '\n') {
                    sb.append("<BR>");
                } else if (c != '\r') {
                    int ci = 0xFFFF & c;
                    if (ci < 160) {
                        sb.append(c);
                    } else {
                        sb.append("&#");
                        sb.append(new Integer(ci).toString());
                        sb.append(';');
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String escapeSQL(String string) {
        return StringUtil.escapeSQL(string, false);
    }

    public static String escapeSQL(String string, boolean escapeBackslashes) {
        if (string == null) {
            return null;
        }
        if (escapeBackslashes) {
            return string.replaceAll("'", "''").replaceAll("\\\\", "\\\\\\\\");
        }
        return string.replaceAll("'", "''");
    }

    public static String filler(char c, int count) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < count) {
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static String filler(String str, int count) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < count) {
            sb.append(str);
            ++i;
        }
        return sb.toString();
    }

    public static String quoteSQL(String string) {
        if (string == null) {
            return "NULL";
        }
        return "'" + StringUtil.escapeSQL(string, false) + "'";
    }

    public static String quoteSQL(String string, boolean escapeBackslashes) {
        if (string == null) {
            return "NULL";
        }
        return "'" + StringUtil.escapeSQL(string, escapeBackslashes) + "'";
    }

    public static String rtrim(String str) {
        int len = str.length();
        char[] val = str.toCharArray();
        int count = len;
        while (len > 0 && val[len - 1] <= ' ') {
            --len;
        }
        return len < count ? str.substring(0, len) : str;
    }

    public static String stringifyProperties(Properties properties) {
        SmartArrayList<String> propList = new SmartArrayList<String>();
        for (Object key : properties.keySet()) {
            propList.add(String.format("%s=\"%s\"", key, properties.getProperty((String)key).replaceAll("[\"\\\\]", "\\\\1")));
        }
        return propList.toString();
    }

    public static String stripBackslashes(String str) {
        return str.replaceAll("\\\\(.)", "$1");
    }

    private StringUtil() {
    }
}

