/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.buckminster.runtime.Trivial;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextUtils {
    public static String EMPTY_STRING = "";

    public static String concat(Collection<String> strings, String delim) {
        if (strings != null && strings.size() > 0) {
            StringBuilder bld = new StringBuilder();
            TextUtils.concat(bld, strings, delim);
            return bld.toString();
        }
        return null;
    }

    public static String concat(String[] strings, String delim) {
        if (strings != null && strings.length > 0) {
            StringBuilder bld = new StringBuilder();
            TextUtils.concat(bld, strings, delim);
            return bld.toString();
        }
        return null;
    }

    public static void concat(StringBuilder builder, Collection<String> strings, String delim) {
        if (strings == null) {
            return;
        }
        boolean needDelim = false;
        for (String str : strings) {
            if (needDelim) {
                builder.append(delim);
            } else {
                needDelim = true;
            }
            builder.append(str);
        }
    }

    public static void concat(StringBuilder builder, String[] strings, String delim) {
        if (strings == null) {
            return;
        }
        int top = strings.length;
        if (top > 0) {
            builder.append(strings[0]);
            int idx = 1;
            while (idx < top) {
                builder.append(delim);
                builder.append(strings[idx]);
                ++idx;
            }
        }
    }

    public static void concat(Writer writer, String[] strings, String delim) throws IOException {
        if (strings == null) {
            return;
        }
        int top = strings.length;
        if (top > 0) {
            writer.append(strings[0]);
            int idx = 1;
            while (idx < top) {
                writer.append(delim);
                writer.append(strings[idx]);
                ++idx;
            }
        }
    }

    public static int indexOf(String[] array, String element) {
        if (array == null || element == null) {
            return -1;
        }
        int idx = array.length;
        while (--idx >= 0) {
            if (element.equals(array[idx])) break;
        }
        return idx;
    }

    public static byte[] makeByteArrayFromHexString(String s) {
        byte[] bytes = new byte[s.length() / 2];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);
            ++i;
        }
        return bytes;
    }

    public static String makeGetter(String propName) {
        int len = propName.length();
        char[] allChars = new char[len + 3];
        allChars[0] = 103;
        allChars[1] = 101;
        allChars[2] = 116;
        allChars[3] = Character.toUpperCase(propName.charAt(0));
        int idx = 1;
        while (idx < len) {
            allChars[idx + 3] = propName.charAt(idx);
            ++idx;
        }
        return new String(allChars);
    }

    public static String makeHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        int i = 0;
        while (i < bytes.length) {
            int v = bytes[i] & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
            ++i;
        }
        return sb.toString();
    }

    public static String notEmptyString(String s) {
        return s == null || s.length() == 0 ? null : s;
    }

    public static String notEmptyTrimmedString(String s) {
        if (s == null || s.length() == 0) {
            s = null;
        } else if ((s = s.trim()).length() == 0) {
            s = null;
        }
        return s;
    }

    public static String notNullString(Object txt) {
        return txt == null ? "" : txt.toString();
    }

    public static String[] split(String str, String delim) {
        if (str == null || str.length() == 0) {
            return Trivial.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> bld = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(str, delim);
        while (tokens.hasMoreTokens()) {
            bld.add(tokens.nextToken());
        }
        return bld.toArray(new String[bld.size()]);
    }

    public static String[] splitAndTrim(String str, String delim) {
        ArrayList<String> bld = null;
        if (str != null) {
            StringTokenizer tokens = new StringTokenizer(str, delim);
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                if (token.length() <= 0) continue;
                if (bld == null) {
                    bld = new ArrayList<String>();
                }
                bld.add(token);
            }
        }
        return bld == null ? Trivial.EMPTY_STRING_ARRAY : bld.toArray(new String[bld.size()]);
    }
}

