/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.internal.actor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.actor.IGlobalContext;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.IAction;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.metadata.ModelCache;
import org.eclipse.buckminster.core.metadata.model.Materialization;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalContext
extends ModelCache
implements IGlobalContext {
    private final ArrayList<Integer> executedEclipseKinds = new ArrayList();
    private final ArrayList<IPath> scheduledRemovals = new ArrayList();
    private final Map<UUID, Object> invocationCache = new HashMap<UUID, Object>();
    private final HashSet<Action> actionsPerformed = new HashSet();
    private final Map<String, ? extends Object> globalProps = RMContext.getGlobalPropertyAdditions();
    private final boolean forcedExecution;
    private final boolean quietExecution;
    private boolean workspaceRefreshPending;
    private IStatus status;
    private List<Resolution> generatedResolutions;
    private List<Materialization> generatedMaterializations;

    public GlobalContext(Map<String, ? extends Object> userProps, boolean forcedExecution, boolean quietExecution) {
        super(userProps);
        this.forcedExecution = forcedExecution;
        this.quietExecution = quietExecution;
    }

    @Override
    public synchronized void addGeneratedResolution(Resolution resolution, IPath location) {
        if (this.generatedResolutions == null) {
            this.generatedResolutions = new ArrayList<Resolution>();
            this.generatedMaterializations = new ArrayList<Materialization>();
        }
        this.generatedResolutions.add(resolution);
        this.generatedMaterializations.add(new Materialization(location, resolution.getComponentIdentifier()));
    }

    @Override
    public Map<String, ? extends Object> getExecutionProperties(Attribute attribute) throws CoreException {
        Map actionProps = attribute instanceof IAction ? ((IAction)((Object)attribute)).getProperties() : Collections.emptyMap();
        int mapSize = this.globalProps.size() + actionProps.size() + 10;
        ExpandingProperties<Object> allProps = new ExpandingProperties<Object>(mapSize);
        allProps.putAll(this.globalProps, true);
        allProps.putAll(actionProps, true);
        allProps.putAll((Map<String, Object>)super.getProperties());
        attribute.addDynamicProperties(allProps);
        return allProps;
    }

    @Override
    public synchronized Materialization getGeneratedMaterialization(IComponentIdentifier ci) {
        if (this.generatedMaterializations != null) {
            for (Materialization mat : this.generatedMaterializations) {
                if (!ci.equals(mat.getComponentIdentifier())) continue;
                return mat;
            }
        }
        return null;
    }

    @Override
    public synchronized Resolution getGeneratedResolution(IComponentRequest request) {
        if (this.generatedResolutions != null) {
            for (Resolution res : this.generatedResolutions) {
                if (!request.designates(res.getComponentIdentifier())) continue;
                return res;
            }
        }
        return null;
    }

    @Override
    public Map<UUID, Object> getInvocationCache() {
        return this.invocationCache;
    }

    @Override
    public synchronized Map<String, ? extends Object> getProperties() {
        Map<String, ? extends Object> userProperties = super.getProperties();
        ExpandingProperties<Object> allProps = new ExpandingProperties<Object>(userProperties.size() + this.globalProps.size());
        allProps.putAll(this.globalProps, true);
        allProps.putAll((Map<String, Object>)userProperties);
        return allProps;
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }

    @Override
    public void scheduleRemoval(IPath path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.Only_absolute_paths_can_be_scheduled_for_removal_0, (Object)path.toOSString()));
        }
        int idx = this.scheduledRemovals.size();
        while (--idx >= 0) {
            IPath alreadyScheduled = this.scheduledRemovals.get(idx);
            if (alreadyScheduled.isPrefixOf(path)) {
                return;
            }
            if (!path.isPrefixOf(alreadyScheduled)) continue;
            this.scheduledRemovals.remove(idx);
        }
        this.scheduledRemovals.add(path);
    }

    public void setStatus(IStatus status) {
        this.status = status;
    }

    void addPerformedAction(Action action) {
        this.actionsPerformed.add(action);
    }

    boolean hasExecutedKind(int kind) {
        return this.executedEclipseKinds.contains(new Integer(kind));
    }

    boolean hasPerformedAction(IAction action) {
        return this.actionsPerformed.contains(action);
    }

    boolean isForcedExecution() {
        return this.forcedExecution;
    }

    boolean isQuietExecution() {
        return this.quietExecution;
    }

    boolean isWorkspaceRefreshPending() {
        return this.workspaceRefreshPending;
    }

    void kindWasExecuted(int kind) {
        Integer objKind = new Integer(kind);
        if (!this.executedEclipseKinds.contains(objKind)) {
            this.executedEclipseKinds.add(objKind);
        }
    }

    /*
     * Exception decompiling
     */
    synchronized void removeScheduled(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void setWorkspaceRefreshPending(boolean flag) {
        this.workspaceRefreshPending = flag;
    }
}

