/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.UUID;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.metadata.ISaxableStorage;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.sax.UUIDKeyed;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractSaxableStorage<T extends UUIDKeyed>
implements ISaxableStorage<T> {
    private final Class<T> clazz;
    private HashMap<String, Method> getters;

    AbstractSaxableStorage(Class<T> clazz) {
        this.clazz = clazz;
    }

    T[] createArray(int length) {
        return (UUIDKeyed[])Array.newInstance(this.clazz, length);
    }

    Class<T> getElementClass() {
        return this.clazz;
    }

    synchronized Method getGetter(String keyName) throws CoreException {
        String key = keyName.toLowerCase();
        if (this.getters == null) {
            this.getters = new HashMap();
        } else {
            Method getter = this.getters.get(key);
            if (getter != null) {
                return getter;
            }
        }
        Class<UUID> retType = UUID.class;
        Method[] methodArray = this.clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            Method method = methodArray[n2];
            int mod = method.getModifiers();
            if (Modifier.isPublic(mod) && !Modifier.isStatic(mod) && method.getReturnType().equals(retType) && method.getParameterTypes().length == 0 && (name = method.getName().toLowerCase()).length() > 3 && name.startsWith("get") && (name = name.substring(3)).equals(key)) {
                this.getters.put(key, method);
                return method;
            }
            ++n2;
        }
        throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.No_such_foreign_key_0, (Object)keyName), (Object[])new Object[0]);
    }
}

