/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata;

import java.io.File;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.metadata.FileStorage;
import org.eclipse.buckminster.core.metadata.ISaxableStorage;
import org.eclipse.buckminster.core.metadata.MemoryStorage;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.Materialization;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.model.WorkspaceBinding;
import org.eclipse.buckminster.core.parser.IParserFactory;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageManager {
    private static StorageManager defaultManager;
    private final ISaxableStorage<CSpec> cspecs;
    private final ISaxableStorage<WorkspaceBinding> wsBindings;
    private final ISaxableStorage<Resolution> resolutions;
    private final ISaxableStorage<Provider> providers;
    private final ISaxableStorage<Materialization> materializations;

    public static synchronized StorageManager getDefault() throws CoreException {
        if (defaultManager == null) {
            defaultManager = new StorageManager(CorePlugin.getDefault().getStateLocation().toFile());
            defaultManager.initialize();
        }
        return defaultManager;
    }

    public StorageManager(File baseLocation) throws CoreException {
        CorePlugin plugin = CorePlugin.getDefault();
        IParserFactory pf = plugin.getParserFactory();
        this.providers = new MemoryStorage<Provider>(Provider.class);
        this.cspecs = new MemoryStorage<CSpec>(CSpec.class);
        this.resolutions = new MemoryStorage<Resolution>(Resolution.class);
        this.materializations = new FileStorage<Materialization>(new File(baseLocation, "materialization"), pf.getMaterializationParser(), Materialization.class, 3);
        this.wsBindings = new FileStorage<WorkspaceBinding>(new File(baseLocation, "workspaceBinding"), pf.getWorkspaceBindingParser(false), WorkspaceBinding.class, 1);
    }

    public ISaxableStorage<CSpec> getCSpecs() throws CoreException {
        return this.cspecs;
    }

    public ISaxableStorage<Materialization> getMaterializations() throws CoreException {
        return this.materializations;
    }

    public ISaxableStorage<Provider> getProviders() throws CoreException {
        return this.providers;
    }

    public ISaxableStorage<Resolution> getResolutions() throws CoreException {
        return this.resolutions;
    }

    public ISaxableStorage<WorkspaceBinding> getWorkspaceBindings() throws CoreException {
        return this.wsBindings;
    }

    private void initialize() throws CoreException {
        if (this.materializations.sequenceChanged() || this.resolutions.sequenceChanged() || this.cspecs.sequenceChanged() || this.providers.sequenceChanged() || this.wsBindings.sequenceChanged()) {
            WorkspaceInfo.forceRefreshOnAll((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

