/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.parser;

import java.util.UUID;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.GeneratorNode;
import org.eclipse.buckminster.core.metadata.parser.BomNodeHandler;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class GeneratorNodeHandler
extends BomNodeHandler {
    public static final String TAG = "generatorNode";
    private GeneratorNode node;

    GeneratorNodeHandler(AbstractHandler parent) {
        super(parent);
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        UUID cspecId = null;
        try {
            cspecId = UUID.fromString(this.getStringValue(attrs, "declaringCSpecId"));
            String component = GeneratorNodeHandler.getOptionalStringValue((Attributes)attrs, (String)"component");
            String attribute = this.getStringValue(attrs, "attribute");
            String generates = this.getStringValue(attrs, "generates");
            String generatesType = GeneratorNodeHandler.getOptionalStringValue((Attributes)attrs, (String)"generatesType");
            String tmp = GeneratorNodeHandler.getOptionalStringValue((Attributes)attrs, (String)"generatesVersion");
            Version generatesVersion = null;
            if (tmp != null) {
                try {
                    generatesVersion = VersionHelper.parseVersion(tmp);
                }
                catch (IllegalArgumentException e) {
                    throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
                }
            }
            this.node = new GeneratorNode((CSpec)this.getWrapped(cspecId), component, attribute, new ComponentIdentifier(generates, generatesType, generatesVersion));
        }
        catch (ClassCastException e) {
            throw new SAXParseException(NLS.bind((String)Messages.Wrapper_0_does_not_wrap_cspec, (Object)cspecId), this.getDocumentLocator());
        }
    }

    BOMNode getDepNode() {
        return this.node;
    }
}

