/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.parser;

import java.util.UUID;
import org.eclipse.buckminster.core.cspec.parser.CSpecHandler;
import org.eclipse.buckminster.core.metadata.model.IDWrapper;
import org.eclipse.buckminster.core.metadata.parser.BillOfMaterialsHandler;
import org.eclipse.buckminster.core.metadata.parser.BomNodeHandler;
import org.eclipse.buckminster.core.metadata.parser.GeneratorNodeHandler;
import org.eclipse.buckminster.core.metadata.parser.IWrapperParent;
import org.eclipse.buckminster.core.metadata.parser.ResolutionHandler;
import org.eclipse.buckminster.core.metadata.parser.ResolvedNodeHandler;
import org.eclipse.buckminster.core.metadata.parser.UnresolvedNodeHandler;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.core.query.parser.ComponentQueryHandler;
import org.eclipse.buckminster.core.rmap.parser.ProviderHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.eclipse.buckminster.sax.UUIDKeyed;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IDWrapperHandler
extends ExtensionAwareHandler
implements ChildPoppedListener {
    public static final String TAG = "idwrapper";
    private final CSpecHandler cspecHandler = new CSpecHandler((AbstractHandler)this);
    private final ResolutionHandler resolutionHandler = new ResolutionHandler((AbstractHandler)this);
    private final ResolvedNodeHandler resolvedNodeHandler = new ResolvedNodeHandler((AbstractHandler)this);
    private final UnresolvedNodeHandler unresolvedNodeHandler = new UnresolvedNodeHandler((AbstractHandler)this);
    private final GeneratorNodeHandler generatorNodeHandler = new GeneratorNodeHandler((AbstractHandler)this);
    private final ComponentQueryHandler componentQueryHandler = new ComponentQueryHandler((AbstractHandler)this, null);
    private BillOfMaterialsHandler billOfMaterialsHandler;
    private UUID id;
    private IDWrapper wrapper;

    public IDWrapperHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) throws SAXException {
        if (child instanceof BomNodeHandler) {
            this.wrapper = new IDWrapper(this.id, ((BomNodeHandler)child).getDepNode());
        } else if (child == this.cspecHandler) {
            this.wrapper = new IDWrapper(this.id, this.cspecHandler.getCSpec());
        } else if (child instanceof ProviderHandler) {
            this.wrapper = new IDWrapper(this.id, ((ProviderHandler)child).getProvider());
        } else if (child == this.resolutionHandler) {
            this.wrapper = new IDWrapper(this.id, this.resolutionHandler.getResolution());
        } else if (child == this.componentQueryHandler) {
            this.wrapper = new IDWrapper(this.id, this.componentQueryHandler.getComponentQuery());
        }
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        ExtensionAwareHandler ch;
        if ("cspec".equals(localName)) {
            ch = this.cspecHandler;
        } else if ("provider".equals(localName)) {
            ch = this.createContentHandler(ProviderHandler.class, uri, attrs);
        } else if ("resolution".equals(localName)) {
            ch = this.resolutionHandler;
        } else if ("resolvedNode".equals(localName)) {
            ch = this.resolvedNodeHandler;
        } else if ("billOfMaterials".equals(localName)) {
            if (this.billOfMaterialsHandler == null) {
                this.billOfMaterialsHandler = new BillOfMaterialsHandler((AbstractHandler)this);
            }
            ch = this.billOfMaterialsHandler;
        } else {
            ch = "unresolvedNode".equals(localName) ? this.unresolvedNodeHandler : ("generatorNode".equals(localName) ? this.generatorNodeHandler : (this.componentQueryHandler.getTAG().equals(localName) ? this.componentQueryHandler : super.createHandler(uri, localName, attrs)));
        }
        return ch;
    }

    public IDWrapper getWrapper() {
        return this.wrapper;
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        this.id = UUID.fromString(this.getStringValue(attrs, "id"));
        this.wrapper = null;
    }

    UUIDKeyed getWrapped(UUID wid) throws SAXException {
        return ((IWrapperParent)this.getParentHandler()).getWrapped(wid);
    }
}

