/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.parser;

import java.util.UUID;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.model.Materialization;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.p2.metadata.Version;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MaterializationHandler
extends ExtensionAwareHandler {
    public static final String TAG = "materialization";
    private Materialization materialization;

    public MaterializationHandler(AbstractHandler parent) {
        super(parent);
    }

    public Materialization getMaterialization() {
        return this.materialization;
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        ComponentIdentifier cid;
        String name = MaterializationHandler.getOptionalStringValue((Attributes)attrs, (String)"name");
        if (name == null) {
            UUID resolutionId = UUID.fromString(this.getStringValue(attrs, "resolutionId"));
            try {
                Resolution res = StorageManager.getDefault().getResolutions().getElement(resolutionId);
                cid = res.getComponentIdentifier();
            }
            catch (CoreException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), (Exception)((Object)e));
            }
        }
        String ctype = this.getComponentType(attrs);
        Version version = null;
        try {
            version = VersionHelper.parseVersionAttributes(attrs);
        }
        catch (CoreException e) {
            throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
        }
        cid = new ComponentIdentifier(name, ctype, version);
        this.materialization = new Materialization(Path.fromPortableString((String)this.getStringValue(attrs, "location")), cid);
    }
}

