/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.mspec.model;

import java.util.Map;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.model.SAXEmitter;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.buckminster.core.mspec.IMaterializationDirective;
import org.eclipse.buckminster.core.mspec.builder.MaterializationDirectiveBuilder;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.IPath;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MaterializationDirective
extends AbstractSaxableElement
implements IMaterializationDirective {
    public static final String ATTR_INSTALL_LOCATION = "installLocation";
    public static final String ATTR_WORKSPACE_LOCATION = "workspaceLocation";
    public static final String ATTR_MATERIALIZER = "materializer";
    public static final String ATTR_CONFLICT_RESOLUTION = "conflictResolution";
    public static final String ATTR_MAX_PARALLEL_JOBS = "maxParallelJobs";
    private final int maxParallelJobs;
    private final Map<String, String> properties;
    private final IPath installLocation;
    private final IPath workspaceLocation;
    private final String materializer;
    private final ConflictResolution conflictResolution;
    private final Documentation documentation;

    public MaterializationDirective(MaterializationDirectiveBuilder builder) {
        this.documentation = builder.getDocumentation();
        IPath tmp = builder.getInstallLocation();
        this.installLocation = tmp == null ? null : tmp.addTrailingSeparator();
        tmp = builder.getWorkspaceLocation();
        this.workspaceLocation = tmp == null ? null : tmp.addTrailingSeparator();
        this.materializer = builder.getMaterializerID();
        this.conflictResolution = builder.getConflictResolution();
        this.properties = ExpandingProperties.createUnmodifiableProperties(builder.getProperties());
        this.maxParallelJobs = builder.getMaxParallelJobs();
    }

    @Override
    public ConflictResolution getConflictResolution() {
        return this.conflictResolution;
    }

    @Override
    public Documentation getDocumentation() {
        return this.documentation;
    }

    @Override
    public IPath getInstallLocation() {
        return this.installLocation;
    }

    @Override
    public String getMaterializerID() {
        return this.materializer;
    }

    @Override
    public int getMaxParallelJobs() {
        return this.maxParallelJobs;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public IPath getWorkspaceLocation() {
        return this.workspaceLocation;
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        if (this.installLocation != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_INSTALL_LOCATION, (String)this.installLocation.toPortableString());
        }
        if (this.workspaceLocation != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_WORKSPACE_LOCATION, (String)this.workspaceLocation.toPortableString());
        }
        if (this.materializer != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_MATERIALIZER, (String)this.materializer);
        }
        if (this.conflictResolution != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_CONFLICT_RESOLUTION, (String)this.conflictResolution.name());
        }
        if (this.maxParallelJobs != -1) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_MAX_PARALLEL_JOBS, (String)Integer.toString(this.maxParallelJobs));
        }
    }

    protected void emitElements(ContentHandler receiver, String namespace, String prefix) throws SAXException {
        if (this.documentation != null) {
            this.documentation.toSax(receiver, namespace, prefix, this.documentation.getDefaultTag());
        }
        SAXEmitter.emitProperties(receiver, this.properties, namespace, prefix, true, false);
    }
}

