/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.reader;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.materializer.P2Materializer;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.model.ResolvedNode;
import org.eclipse.buckminster.core.reader.CatalogReaderType;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IVersionFinder;
import org.eclipse.buckminster.core.reader.P2VersionFinder;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.PublisherUtil;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2ReaderType
extends CatalogReaderType {
    public static final String SIMPLE_ARTIFACTS_TYPE = "org.eclipse.equinox.p2.artifact.repository.simpleRepository";

    public static IArtifactRepository getArtifactRepository(Provider provider, Map<String, ? extends Object> properties, IProgressMonitor monitor) throws CoreException {
        return P2ReaderType.getArtifactRepository(P2ReaderType.getURI(provider, properties), monitor);
    }

    public static IArtifactRepository getArtifactRepository(ProviderMatch providerMatch, IProgressMonitor monitor) throws CoreException {
        return P2ReaderType.getArtifactRepository(providerMatch.getProvider(), providerMatch.getNodeQuery().getProperties(), monitor);
    }

    public static IArtifactRepository getArtifactRepository(URI repoLocation, IProgressMonitor monitor) throws CoreException {
        IArtifactRepositoryManager manager = P2ReaderType.getArtifactRepositoryManager();
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        try {
            IArtifactRepository iArtifactRepository = manager.loadRepository(repoLocation, (IProgressMonitor)subMon.newChild(100));
            return iArtifactRepository;
        }
        catch (ProvisionException e) {
            IArtifactRepository iArtifactRepository = manager.refreshRepository(repoLocation, (IProgressMonitor)subMon.newChild(100));
            return iArtifactRepository;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static IArtifactRepositoryManager getArtifactRepositoryManager() throws CoreException {
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)CorePlugin.getDefault().getResolverAgent().getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            throw new IllegalStateException("No artifact repository manager found");
        }
        return manager;
    }

    public static IInstallableUnit getIU(ProviderMatch providerMatch, IProgressMonitor monitor) throws CoreException {
        VersionMatch vm;
        IMetadataRepository mdr = P2ReaderType.getMetadataRepository(providerMatch, monitor);
        IQueryResult result = mdr.query(QueryUtil.createIUQuery((String)(vm = providerMatch.getVersionMatch()).getArtifactInfo(), (Version)vm.getVersion()), monitor);
        return result.isEmpty() ? null : (IInstallableUnit)result.iterator().next();
    }

    public static IMetadataRepository getMetadataRepository(Provider provider, Map<String, ? extends Object> properties, IProgressMonitor monitor) throws CoreException {
        return P2ReaderType.getMetadataRepository(P2ReaderType.getURI(provider, properties), monitor);
    }

    public static IMetadataRepository getMetadataRepository(ProviderMatch providerMatch, IProgressMonitor monitor) throws CoreException {
        return P2ReaderType.getMetadataRepository(providerMatch.getProvider(), providerMatch.getNodeQuery().getProperties(), monitor);
    }

    public static IMetadataRepository getMetadataRepository(URI repoLocation, IProgressMonitor monitor) throws CoreException {
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)CorePlugin.getDefault().getResolverAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            throw new IllegalStateException("No artifact repository manager found");
        }
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        try {
            IMetadataRepository iMetadataRepository = manager.loadRepository(repoLocation, (IProgressMonitor)subMon.newChild(100));
            return iMetadataRepository;
        }
        catch (ProvisionException e) {
            IMetadataRepository iMetadataRepository = manager.refreshRepository(repoLocation, (IProgressMonitor)subMon.newChild(100));
            return iMetadataRepository;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static IFileArtifactRepository getTempAR(SubMonitor subMon) throws CoreException {
        IFileArtifactRepository tempAr;
        File tempRepositoryFolder = new File(CorePlugin.getDefault().getResolverAgentLocation(), "tempAr");
        IArtifactRepositoryManager manager = P2ReaderType.getArtifactRepositoryManager();
        URI tempRepositoryURI = tempRepositoryFolder.toURI();
        try {
            tempAr = (IFileArtifactRepository)manager.loadRepository(tempRepositoryURI, (IProgressMonitor)subMon);
        }
        catch (ProvisionException e) {
            tempAr = (IFileArtifactRepository)manager.createRepository(tempRepositoryURI, "temporary artifacts artifacts", SIMPLE_ARTIFACTS_TYPE, Collections.emptyMap());
        }
        return tempAr;
    }

    public static URI getURI(Provider provider, Map<String, ? extends Object> properties) throws CoreException {
        return P2Materializer.cleanURIFromImportType(URLUtils.normalizeToURI((String)provider.getURI(properties), (boolean)true));
    }

    @Override
    public String convertFetchFactoryLocator(Map<String, String> fetchFactoryLocator, String componentName) throws CoreException {
        return fetchFactoryLocator.get("repository");
    }

    @Override
    public URI getArtifactURL(Resolution resolution, RMContext context) throws CoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComponentReader getReader(ProviderMatch providerMatch, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRecommendedMaterializer() {
        return "p2";
    }

    public BOMNode getResolution(ProviderMatch providerMatch, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        try {
            IInstallableUnit iu = P2ReaderType.getIU(providerMatch, (IProgressMonitor)subMon.newChild(22));
            if (iu == null) {
                throw new MissingComponentException(providerMatch.getNodeQuery().getComponentRequest().toString());
            }
            MonitorUtils.testCancelStatus((IProgressMonitor)subMon);
            if (Boolean.valueOf(iu.getProperty("org.eclipse.equinox.p2.partial.iu")).booleanValue()) {
                iu = this.resolvePartialIU(iu, providerMatch, subMon.newChild(10));
            } else {
                subMon.worked(10);
            }
            IMetadataRepository mdr = P2ReaderType.getMetadataRepository(providerMatch, (IProgressMonitor)subMon.newChild(2));
            ResolvedNode resolvedNode = new ResolvedNode(providerMatch.getNodeQuery(), new Resolution(providerMatch.createResolution(new CSpecBuilder(providerMatch.getNodeQuery().getProperties(), mdr, iu), false)));
            return resolvedNode;
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }

    @Override
    public IVersionFinder getVersionFinder(Provider provider, IComponentType ctype, NodeQuery nodeQuery, IProgressMonitor monitor) throws CoreException {
        IMetadataRepository mdr = P2ReaderType.getMetadataRepository(provider, nodeQuery.getProperties(), monitor);
        return new P2VersionFinder(provider, ctype, nodeQuery, mdr);
    }

    IInstallableUnit resolvePartialIU(IInstallableUnit iu, ProviderMatch providerMatch, SubMonitor subMon) throws CoreException {
        File bundleFile;
        Logger logger = CorePlugin.getLogger();
        String info = "Converting partial IU for " + iu.getId() + "...";
        subMon.beginTask(info, 1110);
        logger.debug(info, new Object[0]);
        IArtifactRepository sourceAr = P2ReaderType.getArtifactRepository(providerMatch, (IProgressMonitor)subMon.newChild(100));
        MonitorUtils.testCancelStatus((IProgressMonitor)subMon);
        Collection artifacts = iu.getArtifacts();
        IArtifactKey key = (IArtifactKey)artifacts.iterator().next();
        IFileArtifactRepository tempAr = P2ReaderType.getTempAR(subMon.newChild(10));
        MonitorUtils.testCancelStatus((IProgressMonitor)subMon);
        IArtifactRequest request = P2ReaderType.getArtifactRepositoryManager().createMirrorRequest(key, (IArtifactRepository)tempAr, null, null);
        request.perform(sourceAr, (IProgressMonitor)subMon.newChild(1000));
        IStatus result = request.getResult();
        switch (result.getSeverity()) {
            case 1: {
                logger.info(result.getMessage(), new Object[0]);
            }
            case 0: {
                if (tempAr.contains(key)) break;
                throw BuckminsterException.fromMessage((String)"Zero bytes copied while mirroring partial IU artifact %s", (Object[])new Object[]{key});
            }
            case 8: {
                throw new OperationCanceledException();
            }
            default: {
                if (result.getCode() == 1201) {
                    logger.debug("Artifact %s is already present", new Object[]{key});
                    break;
                }
                throw BuckminsterException.wrap((IStatus)result);
            }
        }
        if ((bundleFile = tempAr.getArtifactFile(key)) == null) {
            throw BuckminsterException.fromMessage((String)"Unable to resolve partial IU. Artifact file for %s could not be found", (Object[])new Object[]{key});
        }
        IInstallableUnit preparedIU = PublisherUtil.createBundleIU((IArtifactKey)key, (File)bundleFile);
        if (preparedIU == null) {
            throw BuckminsterException.fromMessage((String)"Unable to resolve partial IU. Artifact file for %s did not contain a bundle manifest", (Object[])new Object[]{key});
        }
        return preparedIU;
    }
}

