/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.reader;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IFileReader;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDescReader
implements IStreamConsumer<IProjectDescription> {
    public static IProjectDescription getProjectDescription(IComponentReader reader, IProgressMonitor monitor) throws CoreException {
        ProjectDescReader pdr = new ProjectDescReader();
        try {
            IProjectDescription projDesc = reader instanceof ICatalogReader ? ((ICatalogReader)reader).readFile(".project", pdr, monitor) : ((IFileReader)reader).readFile(pdr, monitor);
            return projDesc;
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProjectDescription consumeStream(IComponentReader fileReader, String streamName, InputStream stream, IProgressMonitor monitor) throws CoreException {
        monitor = MonitorUtils.ensureNotNull((IProgressMonitor)monitor);
        try {
            IWorkspace ws;
            monitor.beginTask(null, 1);
            monitor.subTask(Messages.Loading_project_description);
            IWorkspace iWorkspace = ws = ResourcesPlugin.getWorkspace();
            synchronized (iWorkspace) {
                IProjectDescription pd = ws.loadProjectDescription(stream);
                MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
                IProjectDescription iProjectDescription = pd;
                return iProjectDescription;
            }
        }
        finally {
            monitor.done();
        }
    }
}

