/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.resolver;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.helpers.AbstractExtension;
import org.eclipse.buckminster.core.helpers.IllegalParameterException;
import org.eclipse.buckminster.core.prefedit.IPreferenceDescriptor;
import org.eclipse.buckminster.core.prefedit.PreferenceDescriptor;
import org.eclipse.buckminster.core.prefedit.PreferenceType;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.IResolver;
import org.eclipse.buckminster.core.resolver.IResourceMapResolverFactory;
import org.eclipse.buckminster.core.resolver.LocalResolver;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.resolver.ResourceMapResolver;
import org.eclipse.buckminster.core.rmap.model.ResourceMap;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ecf.core.security.IConnectContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMapResolverFactory
extends AbstractExtension
implements IResourceMapResolverFactory {
    private static final IEclipsePreferences preferencesNode = new InstanceScope().getNode("org.eclipse.buckminster.runtime");
    private static final IEclipsePreferences defaultNode = new DefaultScope().getNode("org.eclipse.buckminster.runtime");
    public static final String RESOURCE_MAP_URL_PARAM = "resourceMapURL";
    public static final String OVERRIDE_QUERY_URL_PARAM = "overrideQueryURL";
    public static final boolean OVERRIDE_QUERY_URL_DEFAULT = false;
    public static final String LOCAL_RESOLVE_PARAM = "localResolve";
    public static final boolean LOCAL_RESOLVE_DEFAULT = true;
    public static final String RESOLVER_THREADS_MAX_PARAM = "resolverThreadsMax";
    public static final int RESOLVER_THREADS_MAX_DEFAULT = 4;
    private IEclipsePreferences prefsNode;
    private String resourceMapURL;
    private boolean overrideQueryURL = false;
    private boolean localResolve = true;
    private int resolverThreadsMax = 4;
    private static final UUID CACHE_KEY_RESOURCE_MAP = UUID.randomUUID();

    public static void addListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        preferencesNode.addPreferenceChangeListener(listener);
    }

    public static void removeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        preferencesNode.removePreferenceChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceMap getCachedResourceMap(ResolutionContext context, URL url, IConnectContext cctx) throws CoreException {
        String key;
        Map<String, ResourceMap> rmapCache = ResourceMapResolverFactory.getResourceMapCache(context.getUserCache());
        String string = key = url.toString().intern();
        synchronized (string) {
            ResourceMap rmap = rmapCache.get(key);
            if (rmap == null) {
                rmap = ResourceMap.fromURL(url, cctx);
                rmapCache.put(key, rmap);
            }
            return rmap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, ResourceMap> getResourceMapCache(Map<UUID, Object> ctxUserCache) {
        Map<UUID, Object> map = ctxUserCache;
        synchronized (map) {
            Map resourceMapCache = (Map)ctxUserCache.get(CACHE_KEY_RESOURCE_MAP);
            if (resourceMapCache == null) {
                resourceMapCache = Collections.synchronizedMap(new HashMap());
                ctxUserCache.put(CACHE_KEY_RESOURCE_MAP, resourceMapCache);
            }
            return resourceMapCache;
        }
    }

    @Override
    public IResolver createResolver(ResolutionContext context) throws CoreException {
        URL url;
        ComponentQuery query = context.getComponentQuery();
        if (this.isOverrideQueryURL()) {
            url = this.getResourceMapURL();
        } else {
            url = query.getResolvedResourceMapURL();
            if (url == null) {
                url = this.getResourceMapURL();
            }
        }
        return url == null ? new LocalResolver(context) : new ResourceMapResolver(this, context, false);
    }

    @Override
    public IPreferenceDescriptor[] getPreferenceDescriptors() {
        IPreferenceDescriptor[] pds = new PreferenceDescriptor[]{new PreferenceDescriptor(RESOURCE_MAP_URL_PARAM, PreferenceType.String, Messages.Resource_map_URL), new PreferenceDescriptor(OVERRIDE_QUERY_URL_PARAM, PreferenceType.Boolean, Messages.Override_URL_in_Component_Query), new PreferenceDescriptor(LOCAL_RESOLVE_PARAM, PreferenceType.Boolean, Messages.Perform_local_resolution), new PreferenceDescriptor(RESOLVER_THREADS_MAX_PARAM, PreferenceType.Integer, Messages.Maximum_number_of_resolver_threads)};
        pds[3].setTextWidth(2);
        pds[3].setIntegerRange(1, 12);
        return pds;
    }

    public synchronized IEclipsePreferences getPreferences() {
        if (this.prefsNode == null) {
            this.prefsNode = (IEclipsePreferences)preferencesNode.node(this.getId());
            this.initDefaultPreferences();
        }
        return this.prefsNode;
    }

    @Override
    public int getResolutionPriority() {
        return 0;
    }

    @Override
    public int getResolverThreadsMax() {
        return this.getPreferences().getInt(RESOLVER_THREADS_MAX_PARAM, this.resolverThreadsMax);
    }

    @Override
    public ResourceMap getResourceMap(ResolutionContext context, URL url, IConnectContext cctx) throws CoreException {
        if (url == null || this.isOverrideQueryURL()) {
            url = this.getResourceMapURL();
        }
        return ResourceMapResolverFactory.getCachedResourceMap(context, url, cctx);
    }

    @Override
    public URL getResourceMapURL() throws CoreException {
        try {
            return URLUtils.normalizeToURL((String)this.getPreferences().get(RESOURCE_MAP_URL_PARAM, this.resourceMapURL));
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    @Override
    public void initDefaultPreferences() {
        IEclipsePreferences dfltNode = (IEclipsePreferences)defaultNode.node(this.getId());
        if (dfltNode.getInt(RESOLVER_THREADS_MAX_PARAM, 0) == 0) {
            dfltNode.putBoolean(OVERRIDE_QUERY_URL_PARAM, false);
            dfltNode.putBoolean(LOCAL_RESOLVE_PARAM, true);
            dfltNode.putInt(RESOLVER_THREADS_MAX_PARAM, 4);
        }
    }

    @Override
    public boolean isLocalResolve() {
        return this.getPreferences().getBoolean(LOCAL_RESOLVE_PARAM, this.localResolve);
    }

    @Override
    public boolean isOverrideQueryURL() {
        return this.getPreferences().getBoolean(OVERRIDE_QUERY_URL_PARAM, this.overrideQueryURL);
    }

    @Override
    public void setExtensionParameter(String key, String value) throws CoreException {
        if (RESOURCE_MAP_URL_PARAM.equalsIgnoreCase(key)) {
            this.resourceMapURL = value;
        } else if (OVERRIDE_QUERY_URL_PARAM.equalsIgnoreCase(key)) {
            this.overrideQueryURL = Boolean.parseBoolean(value);
        } else if (LOCAL_RESOLVE_PARAM.equalsIgnoreCase(key)) {
            this.localResolve = Boolean.parseBoolean(value);
        } else if (RESOLVER_THREADS_MAX_PARAM.equalsIgnoreCase(key)) {
            this.resolverThreadsMax = Integer.parseInt(value);
        } else {
            throw new IllegalParameterException("org.eclipse.buckminster.core.queryResolvers", this.getId(), key);
        }
    }

    public void setLocalResolve(boolean localResolve) {
        this.getPreferences().putBoolean(LOCAL_RESOLVE_PARAM, localResolve);
    }

    public void setOverrideQueryURL(boolean overrideQueryURL) {
        this.getPreferences().putBoolean(OVERRIDE_QUERY_URL_PARAM, overrideQueryURL);
    }

    public void setResolverThreadsMax(int resolverThreadsMax) {
        this.getPreferences().putInt(RESOLVER_THREADS_MAX_PARAM, resolverThreadsMax);
    }

    public void setResourceMapURL(URL resourceMapURL) {
        this.getPreferences().put(RESOURCE_MAP_URL_PARAM, resourceMapURL.toExternalForm());
    }
}

