/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.rmap.model.TransformerMismatchException;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class BidirectionalTransformer
extends AbstractSaxableElement {
    public static final String TAG = "transform";
    public static final String ATTR_TO_PATTERN = "toPattern";
    public static final String ATTR_TO_REPLACEMENT = "toReplacement";
    public static final String ATTR_FROM_PATTERN = "fromPattern";
    public static final String ATTR_FROM_REPLACEMENT = "fromReplacement";
    private final Pattern toPattern;
    private final String toReplacement;
    private final Pattern fromPattern;
    private final String fromReplacement;

    private static String replace(String source, Pattern pattern, String replacement) {
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            StringBuffer sb = new StringBuffer();
            do {
                matcher.appendReplacement(sb, replacement);
            } while (matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return null;
    }

    public BidirectionalTransformer(Pattern toPattern, String toReplacement, Pattern fromPattern, String fromReplacement) {
        this.toPattern = toPattern;
        this.toReplacement = toReplacement;
        this.fromPattern = fromPattern;
        this.fromReplacement = fromReplacement;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public final Pattern getFromPattern() {
        return this.fromPattern;
    }

    public final String getFromReplacement() {
        return this.fromReplacement;
    }

    public final Pattern getToPattern() {
        return this.toPattern;
    }

    public final String getToReplacement() {
        return this.toReplacement;
    }

    public String transformFrom(String source) throws TransformerMismatchException {
        return this.transform(source, this.fromPattern, this.fromReplacement, this.toPattern, this.toReplacement);
    }

    public String transformTo(String source) throws TransformerMismatchException {
        return this.transform(source, this.toPattern, this.toReplacement, this.fromPattern, this.fromReplacement);
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_TO_PATTERN, (String)this.toPattern.toString());
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_TO_REPLACEMENT, (String)this.toReplacement);
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_FROM_PATTERN, (String)this.fromPattern.toString());
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_FROM_REPLACEMENT, (String)this.fromReplacement);
    }

    private String transform(String source, Pattern pattern, String replacement, Pattern reversePattern, String reverseReplacement) throws TransformerMismatchException {
        String result = BidirectionalTransformer.replace(source, pattern, replacement);
        if (result == null) {
            return null;
        }
        String reverse = BidirectionalTransformer.replace(result, reversePattern, reverseReplacement);
        if (reverse == null) {
            return null;
        }
        if (source.equals(reverse)) {
            return result;
        }
        throw new TransformerMismatchException(this);
    }
}

