/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.model;

import java.util.regex.Pattern;
import org.eclipse.buckminster.core.rmap.model.ResourceMap;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class Matcher
extends AbstractSaxableElement {
    public static final String ATTR_PATTERN = "pattern";
    private final ResourceMap owner;
    private final Pattern pattern;

    public Matcher(ResourceMap owner, String pattern) {
        this.owner = owner;
        this.pattern = pattern == null ? null : Pattern.compile(pattern);
    }

    public final ResourceMap getOwner() {
        return this.owner;
    }

    public final Pattern getPattern() {
        return this.pattern;
    }

    public final boolean matches(String componentName) {
        return this.pattern == null || this.pattern.matcher(componentName).find();
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        if (this.pattern != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_PATTERN, (String)this.pattern.toString());
        }
    }
}

