/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.ProviderScore;
import org.eclipse.buckminster.core.rmap.model.ResourceMap;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchPath
extends AbstractSaxableElement {
    public static final String TAG = "searchPath";
    public static final String ATTR_NAME = "name";
    private final String name;
    private final ArrayList<Provider> providers = new ArrayList();
    private final ResourceMap resourceMap;

    public SearchPath(ResourceMap rmap, String name) {
        this.resourceMap = rmap;
        this.name = name;
    }

    public void addPrefixMappings(HashMap<String, String> prefixMappings) {
        for (Provider provider : this.providers) {
            provider.addPrefixMappings(prefixMappings);
        }
    }

    public final void addProvider(Provider provider) {
        this.providers.add(provider);
    }

    public String getDefaultTag() {
        return TAG;
    }

    public final String getName() {
        return this.name;
    }

    public ProviderMatch getProvider(NodeQuery query, List<Provider> noGoodList, MultiStatus problemCollector, IProgressMonitor monitor) throws CoreException {
        int provCnt = this.providers.size();
        if (provCnt == 0) {
            throw new CoreException((IStatus)problemCollector);
        }
        monitor.beginTask("Matching providers", provCnt * 1000);
        try {
            ProviderMatch bestMatch = null;
            VersionRange desiredVersion = query.getVersionRange();
            for (Provider provider : this.providers) {
                if (noGoodList.contains(provider)) continue;
                Filter[] filterHandle = new Filter[1];
                if (!provider.isFilterMatchFor(query, filterHandle)) {
                    query.logDecision(ResolverDecisionType.FILTER_MISMATCH, filterHandle[0]);
                    continue;
                }
                query.logDecision(ResolverDecisionType.TRYING_PROVIDER, provider.getReaderTypeId(), this.getProviderURI(query, provider));
                ProviderMatch match = provider.findMatch(query, problemCollector, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
                if (match == null) {
                    noGoodList.add(provider);
                    continue;
                }
                String readerType = provider.getReaderTypeId();
                ProviderScore score = match.getProviderScore();
                if (score.ordinal() >= ProviderScore.FAIR.ordinal() && "local".equals(readerType) || score.ordinal() >= ProviderScore.GOOD.ordinal() && desiredVersion != null && desiredVersion.getMinimum().equals(match.getVersionMatch().getVersion()) && desiredVersion.getMinimum().equals(desiredVersion.getMaximum())) {
                    bestMatch = match;
                    break;
                }
                if (bestMatch == null || match.compareTo(bestMatch) > 0) {
                    if (bestMatch != null) {
                        Provider rejected = bestMatch.getOriginalProvider();
                        query.logDecision(ResolverDecisionType.REJECTING_PROVIDER, rejected.getReaderTypeId(), this.getProviderURI(query, rejected), NLS.bind((String)Messages._0_1_is_producing_a_better_match, (Object)provider.getReaderTypeId(), (Object)this.getProviderURI(query, provider)));
                    }
                    bestMatch = match;
                    continue;
                }
                Provider best = bestMatch.getOriginalProvider();
                query.logDecision(ResolverDecisionType.REJECTING_PROVIDER, provider.getReaderTypeId(), this.getProviderURI(query, provider), NLS.bind((String)Messages._0_1_is_producing_a_better_match, (Object)best.getReaderTypeId(), (Object)this.getProviderURI(query, best)));
            }
            if (bestMatch == null) {
                query.logDecision(ResolverDecisionType.PROVIDER_NOT_FOUND, new Object[0]);
                throw new CoreException((IStatus)problemCollector);
            }
            Provider best = bestMatch.getOriginalProvider();
            query.logDecision(ResolverDecisionType.USING_PROVIDER, best.getReaderTypeId(), this.getProviderURI(query, best));
            ProviderMatch providerMatch = bestMatch;
            return providerMatch;
        }
        finally {
            monitor.done();
        }
    }

    public List<Provider> getProviders() {
        return this.providers;
    }

    public ResourceMap getResourceMap() {
        return this.resourceMap;
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_NAME, (String)this.name);
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        for (Provider provider : this.providers) {
            provider.toSax(handler, namespace, prefix, provider.getDefaultTag());
        }
    }

    String getProviderURI(NodeQuery query, Provider provider) {
        return String.valueOf(provider.getURI().toString()) + '[' + provider.getURI(this.resourceMap.getProperties(query.getProperties())) + ']';
    }
}

