/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.parser;

import java.util.ArrayList;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.core.rmap.model.BidirectionalTransformer;
import org.eclipse.buckminster.core.rmap.model.VersionConverterDesc;
import org.eclipse.buckminster.core.rmap.parser.BidirectionalTransformerHandler;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IVersionFormat;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionFormatException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class VersionConverterHandler
extends ExtensionAwareHandler
implements ChildPoppedListener {
    static final String TAG = "versionConverter";
    private String type;
    private IVersionFormat versionFormat;
    private final BidirectionalTransformerHandler transformerHandler = new BidirectionalTransformerHandler((AbstractHandler)this);
    private final ArrayList<BidirectionalTransformer> transformers = new ArrayList();

    public VersionConverterHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) throws SAXException {
        if (child instanceof BidirectionalTransformerHandler) {
            this.transformers.add(((BidirectionalTransformerHandler)child).getTransformer());
        }
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        BidirectionalTransformerHandler ch = "transform".equals(localName) ? this.transformerHandler : super.createHandler(uri, localName, attrs);
        return ch;
    }

    public VersionConverterDesc getVersionConverter() {
        return new VersionConverterDesc(this.type, this.versionFormat, this.transformers.toArray(new BidirectionalTransformer[this.transformers.size()]));
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        this.type = this.getStringValue(attrs, "type");
        String tmp = VersionConverterHandler.getOptionalStringValue((Attributes)attrs, (String)"versionFormat");
        if (tmp != null) {
            try {
                this.versionFormat = Version.compile((String)tmp);
            }
            catch (VersionFormatException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), (Exception)((Object)e));
            }
        }
        tmp = VersionConverterHandler.getOptionalStringValue((Attributes)attrs, (String)"versionType");
        if (tmp == null) {
            this.versionFormat = null;
        } else {
            try {
                this.versionFormat = VersionHelper.getVersionType(tmp).getFormat();
            }
            catch (CoreException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), (Exception)((Object)e));
            }
        }
        this.transformers.clear();
    }
}

