/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.reader.IVersionFinder;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolverDecision;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.ProviderScore;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.equinox.p2.metadata.Version;

public abstract class AbstractVersionFinder
implements IVersionFinder {
    private final Provider provider;
    private final NodeQuery query;
    private final IComponentType componentType;

    public AbstractVersionFinder(Provider provider, IComponentType componentType, NodeQuery query) {
        this.provider = provider;
        this.query = query;
        this.componentType = componentType;
    }

    public void close() {
    }

    public IComponentType getComponentType() {
        return this.componentType;
    }

    public IConnectContext getConnectContext() {
        IConnectContext cctx = this.provider.getConnectContext();
        if (cctx == null) {
            cctx = this.query.getComponentQuery().getConnectContext();
        }
        return cctx;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public ProviderMatch getProviderMatch(VersionMatch versionMatch, IComponentType ctypeUsed, ProviderScore score) throws CoreException {
        return new ProviderMatch(this.provider, ctypeUsed, versionMatch, score, this.query);
    }

    public NodeQuery getQuery() {
        return this.query;
    }

    public ResolverDecision logDecision(ComponentRequest request, ResolverDecisionType decisionType, Object ... args) {
        return this.query.logDecision(decisionType, args);
    }

    public ResolverDecision logDecision(ResolverDecisionType decisionType, Object ... args) {
        return this.query.logDecision(decisionType, args);
    }

    protected Version getVersionFromArtifacts(VersionSelector branchOrTag, IProgressMonitor monitor) throws CoreException {
        VersionMatch match = new VersionMatch(null, branchOrTag, this.query.getRevision(), this.query.getTimestamp(), null);
        ProviderMatch rInfo = new ProviderMatch(this.provider, this.componentType, match, this.query);
        return this.componentType.getComponentVersion(rInfo, monitor);
    }
}

