/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.version.Branch;
import org.eclipse.buckminster.core.version.Tag;
import org.eclipse.osgi.util.NLS;

public abstract class VersionSelector {
    public static final String DEFAULT_BRANCH = "main";
    public static final int BRANCH = 0;
    public static final VersionSelector[] EMPTY_PATH = new VersionSelector[0];
    public static final int TAG = 1;
    public static final char TAG_PREFIX = '/';
    private final String name;

    public static VersionSelector branch(String string) {
        return VersionSelector.fromString(string, false);
    }

    public static VersionSelector[] fromPath(String string) {
        String[] strings = TextUtils.split(string, ",");
        int idx = strings.length;
        if (idx == 0) {
            return EMPTY_PATH;
        }
        VersionSelector[] path = new VersionSelector[idx];
        while (--idx >= 0) {
            path[idx] = VersionSelector.fromString(strings[idx]);
        }
        return path;
    }

    public static VersionSelector fromString(String string) {
        boolean isTag = false;
        if (string != null && string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
            isTag = true;
        }
        return VersionSelector.fromString(string, isTag);
    }

    public static int indexOf(VersionSelector[] path, VersionSelector branchOrTag) {
        if (path == null) {
            return -1;
        }
        int idx = path.length;
        while (--idx >= 0) {
            VersionSelector pathEntry = path[idx];
            if (branchOrTag != null ? branchOrTag.equals(path[idx]) : pathEntry.isDefault()) break;
        }
        return idx;
    }

    public static VersionSelector tag(String string) {
        return VersionSelector.fromString(string, true);
    }

    public static String toString(VersionSelector[] path) {
        int top;
        int n = top = path == null ? 0 : path.length;
        if (top == 0) {
            return null;
        }
        VersionSelector first = path[0];
        if (top == 1) {
            return first.toString();
        }
        StringBuilder bld = new StringBuilder();
        first.toString(bld);
        int idx = 1;
        while (idx < top) {
            bld.append(',');
            path[idx].toString(bld);
            ++idx;
        }
        return bld.toString();
    }

    private static VersionSelector fromString(String string, boolean isTag) {
        if (string != null) {
            int top = string.length();
            int idx = 0;
            while (idx < top) {
                char c = string.charAt(idx);
                if (c == '/') {
                    throw new IllegalArgumentException(Messages.The_slash_character_only_legal_at_first_position_of_branch_tag_qualifier);
                }
                if (c == ',' || Character.isWhitespace(c) || Character.isISOControl(c)) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.The_0_character_is_illegal_in_branch_tag_qualifier, (Object)Character.valueOf(c)));
                }
                ++idx;
            }
            if (top > 0) {
                return isTag ? new Tag(string) : new Branch(string);
            }
        }
        throw new IllegalArgumentException(Messages.A_branch_tag_qualifier_cannot_be_empty);
    }

    VersionSelector(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o instanceof VersionSelector) {
            VersionSelector that = (VersionSelector)o;
            return this.getType() == that.getType() && this.name.equals(that.name);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public abstract int getType();

    public int hashCode() {
        return this.name.hashCode() << 1 | this.getType();
    }

    public abstract boolean isDefault();

    public String toString() {
        StringBuilder bld = new StringBuilder();
        this.toString(bld);
        return bld.toString();
    }

    public void toString(StringBuilder bld) {
        bld.append(this.name);
    }

    public String viewNameToString() {
        StringBuilder bld = new StringBuilder();
        this.viewNameToString(bld);
        return bld.toString();
    }

    public abstract void viewNameToString(StringBuilder var1);
}

