/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cvspkg.scheme.cvspkg;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.common.model.Format;
import org.eclipse.buckminster.core.helpers.AccessibleByteArrayOutputStream;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.query.builder.ComponentQueryBuilder;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.cvspkg.Messages;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class Handler
extends AbstractURLStreamHandlerService {
    public static final String PROTOCOL = "cvs";

    public URLConnection openConnection(URL url) throws IOException {
        return new CVSConnection(url);
    }

    class CVSConnection
    extends URLConnection {
        private ICatalogReader reader;
        private String fileName;

        protected CVSConnection(URL entryURL) {
            super(entryURL);
        }

        public void connect() throws IOException {
            if (this.connected) {
                return;
            }
            try {
                String cvsProto;
                URI uri = this.getURL().toURI();
                Map params = URLUtils.queryAsParameters((String)uri.getQuery());
                String host = uri.getHost();
                if (host == null) {
                    throw new MalformedURLException(Messages.cvs_URL_host_cannot_be_empty);
                }
                String rootStr = uri.getPath();
                if (rootStr == null) {
                    throw new MalformedURLException(Messages.cvs_URL_path_cannot_be_empty);
                }
                Path rootPath = new Path(rootStr);
                if (!rootPath.isAbsolute()) {
                    throw new MalformedURLException(Messages.cvs_URL_path_must_be_absolute);
                }
                if (rootPath.segmentCount() < 1) {
                    throw new MalformedURLException(Messages.cvs_URL_path_must_have_segment);
                }
                if (rootPath.hasTrailingSeparator()) {
                    throw new MalformedURLException(Messages.cvs_URL_path_must_not_have_trailing_separator);
                }
                String moduleStr = uri.getFragment();
                if (moduleStr == null) {
                    throw new MalformedURLException(NLS.bind((String)Messages.cvs_URL_must_end_with_0, (Object)("#<" + Messages.cvs_URL_module_path + ">")));
                }
                Path modulePath = new Path(moduleStr);
                if (!modulePath.isAbsolute()) {
                    throw new MalformedURLException(Messages.cvs_URL_module_must_be_absolute);
                }
                if (modulePath.segmentCount() < 1) {
                    throw new MalformedURLException(Messages.cvs_URL_module_must_have_segment);
                }
                if (modulePath.hasTrailingSeparator()) {
                    throw new MalformedURLException(Messages.cvs_URL_module_must_not_have_trailing_separator);
                }
                String user = uri.getUserInfo();
                if (user == null) {
                    user = "anonymous";
                }
                if ((cvsProto = (String)params.get("method")) == null) {
                    cvsProto = "pserver";
                }
                this.fileName = modulePath.lastSegment();
                modulePath = modulePath.removeLastSegments(1);
                StringBuilder bld = new StringBuilder();
                bld.append(':');
                bld.append(cvsProto);
                bld.append(':');
                bld.append(user);
                bld.append('@');
                bld.append(host);
                bld.append(':');
                bld.append(rootPath.toPortableString());
                if (modulePath.segmentCount() > 0) {
                    bld.append(',');
                    bld.append(modulePath.toPortableString());
                }
                CorePlugin plugin = CorePlugin.getDefault();
                String versionSelector = (String)params.get("version");
                IReaderType cvsReaderType = plugin.getReaderType(Handler.PROTOCOL);
                VersionMatch vm = versionSelector == null ? null : new VersionMatch(null, VersionSelector.fromString((String)versionSelector), -1L, null, null);
                NullProgressMonitor nullMon = new NullProgressMonitor();
                Provider provider = new Provider(null, Handler.PROTOCOL, new String[]{"unknown"}, null, new Format(bld.toString()), null, null, null, null, null, null);
                ComponentQueryBuilder cqBld = new ComponentQueryBuilder();
                cqBld.getRootRequestBuilder().setName(this.fileName);
                if (vm == null) {
                    vm = VersionMatch.DEFAULT;
                }
                this.reader = (ICatalogReader)cvsReaderType.getReader(provider, plugin.getComponentType("unknown"), new ResolutionContext(cqBld.createComponentQuery()).getRootNodeQuery(), vm, (IProgressMonitor)nullMon);
            }
            catch (URISyntaxException e) {
                throw new MalformedURLException(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new MalformedURLException(e.getMessage());
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                Throwable t = e.getCause();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new IOException(e.getMessage());
            }
            this.connected = true;
        }

        public InputStream getInputStream() throws IOException {
            this.connect();
            try {
                return (InputStream)this.reader.readFile(this.fileName, (IStreamConsumer)new IStreamConsumer<InputStream>(){

                    public InputStream consumeStream(IComponentReader componentReader, String streamName, InputStream stream, IProgressMonitor monitor) throws IOException {
                        AccessibleByteArrayOutputStream builder = new AccessibleByteArrayOutputStream();
                        FileUtils.copyFile((InputStream)stream, (OutputStream)builder, (IProgressMonitor)monitor);
                        return new FilterInputStream(builder.getInputStream()){

                            public void close() throws IOException {
                                try {
                                    super.close();
                                }
                                finally {
                                    CVSConnection.this.reader.close();
                                }
                            }
                        };
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Throwable t = e.getCause();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new IOException(e.getMessage());
            }
        }
    }
}

