/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.download;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.buckminster.download.ICache;
import org.eclipse.buckminster.download.Messages;
import org.eclipse.buckminster.download.internal.CacheImpl;
import org.eclipse.buckminster.download.internal.FileReader;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.FileInfoBuilder;
import org.eclipse.buckminster.runtime.IFileInfo;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.osgi.util.NLS;

public class DownloadManager {
    private static ICache instance;

    public static IConnectContext createConnectContext(URL[] urlHandle) throws CoreException {
        IConnectContext cctx;
        URL url = urlHandle[0];
        String userInfo = url.getUserInfo();
        if (userInfo == null || userInfo.length() == 0) {
            return null;
        }
        int colonIdx = userInfo.indexOf(58);
        if (colonIdx >= 0) {
            String password = userInfo.substring(colonIdx + 1);
            cctx = colonIdx == 0 ? ConnectContextFactory.createPasswordConnectContext((String)password) : ConnectContextFactory.createUsernamePasswordConnectContext((String)userInfo.substring(0, colonIdx), (Object)password);
        } else {
            cctx = ConnectContextFactory.createUsernamePasswordConnectContext((String)userInfo, null);
        }
        try {
            URI uri = url.toURI();
            uri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            urlHandle[0] = uri.toURL();
        }
        catch (URISyntaxException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        return cctx;
    }

    public static synchronized ICache getCache() throws CoreException {
        if (instance != null) {
            return instance;
        }
        File buckDir = null;
        if (DownloadManager.isWindows()) {
            File appData = null;
            String appDataEnv = System.getenv("APPDATA");
            if (appDataEnv != null) {
                appData = new File(appDataEnv);
            } else {
                String userHome = System.getProperty("user.home");
                if (userHome != null) {
                    appData = new File(userHome, "Application Data");
                }
            }
            if (appData != null) {
                buckDir = new File(appData, "buckminster");
            }
        } else {
            String userHome = System.getProperty("user.home");
            if (userHome != null) {
                buckDir = new File(new File(userHome), ".buckminster");
            }
        }
        if (buckDir == null) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.system_property_0_not_set, (Object)"user.home"), (Object[])new Object[0]);
        }
        instance = new CacheImpl(new File(buckDir, "repository"));
        return instance;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("windows");
    }

    public static InputStream read(URL url, IConnectContext cctx) throws CoreException, FileNotFoundException {
        try {
            url = FileLocator.toFileURL((URL)url);
            if ("file".equalsIgnoreCase(url.getProtocol())) {
                File file = new File(url.toURI());
                return new FileInputStream(file);
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (URISyntaxException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        if (cctx == null) {
            URL[] uh = new URL[]{url};
            cctx = DownloadManager.createConnectContext(uh);
            url = uh[0];
        }
        FileReader reader = new FileReader(cctx);
        return reader.read(url);
    }

    public static IFileInfo readInfo(URL url, IConnectContext cctx) throws CoreException, FileNotFoundException {
        if (cctx == null) {
            URL[] uh = new URL[]{url};
            cctx = DownloadManager.createConnectContext(uh);
            url = uh[0];
        }
        FileReader reader = new FileReader(cctx);
        return reader.readInfo(url);
    }

    public static IFileInfo readInto(URL url, IConnectContext cctx, OutputStream output, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        block8: {
            FileInfoBuilder fileInfoBuilder;
            url = FileLocator.toFileURL((URL)url);
            if (!"file".equalsIgnoreCase(url.getProtocol())) break block8;
            File file = new File(url.toURI());
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                IOUtils.copy((InputStream)input, (OutputStream)output, (IProgressMonitor)monitor);
                fileInfoBuilder = new FileInfoBuilder(file);
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.close((Closeable)input);
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw e;
                }
                catch (URISyntaxException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
                catch (IOException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
            }
            IOUtils.close((Closeable)input);
            return fileInfoBuilder;
        }
        if (cctx == null) {
            URL[] uh = new URL[]{url};
            cctx = DownloadManager.createConnectContext(uh);
            url = uh[0];
        }
        FileReader reader = new FileReader(cctx);
        reader.readInto(url, output, monitor);
        return reader.getLastFileInfo();
    }
}

