/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.download;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.download.IDecompressor;
import org.eclipse.buckminster.download.IExpander;
import org.eclipse.buckminster.download.Messages;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.NullOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ecf.core.util.StringUtils;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Installer {
    private static final HashMap<String, Installer> decompressorCache = new HashMap();
    private static final HashMap<String, Installer> installerCache = new HashMap();
    private static final Installer plainInstaller = new Installer(null, null);
    private final List<IDecompressor> decompressors;
    private final IExpander expander;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Installer getInstaller(String fileName, boolean expand) throws CoreException {
        HashMap<String, Installer> hashMap = installerCache;
        synchronized (hashMap) {
            int n;
            HashMap<String, Installer> cache = expand ? installerCache : decompressorCache;
            for (Map.Entry entry : cache.entrySet()) {
                if (!fileName.endsWith((String)entry.getKey())) continue;
                return (Installer)entry.getValue();
            }
            IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] elems = extRegistry.getConfigurationElementsFor("org.eclipse.buckminster.download.decompressors");
            int idx = elems.length;
            String[][] suffixes = new String[idx][];
            while (--idx >= 0) {
                suffixes[idx] = StringUtils.split((String)elems[idx].getAttribute("suffixes"), (char)',');
            }
            ArrayList<IDecompressor> decompressorList = null;
            String chewedName = fileName;
            while (chewedName.length() > 0) {
                int matchIdx = -1;
                int matchLen = -1;
                idx = elems.length;
                block6: while (--idx >= 0) {
                    String[] stringArray = suffixes[idx];
                    n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String suffix = stringArray[n2];
                        if (suffix.length() > matchLen && chewedName.endsWith(suffix)) {
                            matchLen = suffix.length();
                            matchIdx = idx;
                            break block6;
                        }
                        ++n2;
                    }
                }
                if (matchIdx < 0) break;
                if (decompressorList == null) {
                    decompressorList = new ArrayList<IDecompressor>();
                }
                IConfigurationElement elem = elems[matchIdx];
                decompressorList.add((IDecompressor)IDecompressor.class.cast(elem.createExecutableExtension("class")));
                chewedName = chewedName.substring(0, chewedName.length() - matchLen);
            }
            IExpander expander = null;
            if (expand) {
                elems = extRegistry.getConfigurationElementsFor("org.eclipse.buckminster.download.expanders");
                idx = elems.length;
                suffixes = new String[idx][];
                while (--idx >= 0) {
                    suffixes[idx] = StringUtils.split((String)elems[idx].getAttribute("suffixes"), (char)',');
                }
                int matchIdx = -1;
                int matchLen = -1;
                idx = elems.length;
                block9: while (--idx >= 0) {
                    String[] stringArray = suffixes[idx];
                    int n3 = stringArray.length;
                    n = 0;
                    while (n < n3) {
                        String suffix = stringArray[n];
                        if (suffix.length() > matchLen && chewedName.endsWith(suffix)) {
                            matchLen = suffix.length();
                            matchIdx = idx;
                            break block9;
                        }
                        ++n;
                    }
                }
                if (matchIdx >= 0) {
                    chewedName = chewedName.substring(0, chewedName.length() - matchLen);
                    expander = (IExpander)IExpander.class.cast(elems[matchIdx].createExecutableExtension("class"));
                }
            }
            if (decompressorList == null && expander == null) {
                int lastDot = fileName.lastIndexOf(46);
                if (lastDot >= 0 && lastDot < fileName.length() - 1 && Character.isLetter(fileName.charAt(lastDot + 1))) {
                    cache.put(fileName.substring(lastDot), plainInstaller);
                }
                return plainInstaller;
            }
            String fullSuffixMatch = fileName.substring(chewedName.length());
            Installer validator = new Installer(decompressorList, expander);
            cache.put(fullSuffixMatch, validator);
            return validator;
        }
    }

    public static Installer getPlainInstaller() {
        return plainInstaller;
    }

    private Installer(List<IDecompressor> decompressors, IExpander expander) {
        this.decompressors = decompressors == null ? Collections.emptyList() : decompressors;
        this.expander = expander;
    }

    public void install(InputStream input, File destination, FileFilter fileFilter, boolean flattenHierarchy, IProgressMonitor monitor) throws IOException, CoreException {
        block13: {
            int dcCount = this.decompressors.size();
            MonitorUtils.begin((IProgressMonitor)monitor, (int)(100 + dcCount * 100));
            if (dcCount > 0) {
                input = new FilterInputStream(input){

                    public void close() {
                    }
                };
                for (IDecompressor decompressor : this.decompressors) {
                    input = decompressor.decompress(input, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
                }
            }
            try {
                IProgressMonitor subMon = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100);
                if (this.expander != null) {
                    this.expander.setFilter(fileFilter);
                    this.expander.setFlattenHierarchy(flattenHierarchy);
                    this.expander.expand(input, destination, subMon);
                    break block13;
                }
                Object output = null;
                try {
                    if (destination == null) {
                        output = NullOutputStream.INSTANCE;
                    } else {
                        File parentFolder = destination.getParentFile();
                        if (parentFolder != null && !parentFolder.isDirectory() && !parentFolder.mkdirs()) {
                            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.unable_to_access_directory_0, (Object)parentFolder), (Object[])new Object[0]);
                        }
                        output = new FileOutputStream(destination);
                    }
                    IOUtils.copy((InputStream)input, (OutputStream)output, (IProgressMonitor)subMon);
                }
                finally {
                    IOUtils.close((Closeable)output);
                }
                MonitorUtils.done((IProgressMonitor)subMon);
            }
            finally {
                if (dcCount > 0) {
                    IOUtils.close((Closeable)input);
                }
                MonitorUtils.done((IProgressMonitor)monitor);
            }
        }
    }

    public void install(InputStream input, File destination, IProgressMonitor monitor) throws IOException, CoreException {
        this.install(input, destination, null, false, monitor);
    }

    public void validate(File file, IProgressMonitor monitor) throws CoreException {
        if (this.decompressors.size() == 0 && this.expander == null) {
            return;
        }
        FileInputStream input = null;
        try {
            try {
                input = new FileInputStream(file);
                this.install(input, null, monitor);
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(input);
            throw throwable;
        }
        IOUtils.close((Closeable)input);
    }
}

