/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.download.policy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.buckminster.download.Messages;
import org.eclipse.osgi.util.NLS;

public class Hex {
    public static final int MAX_FAILURES = 2;

    public static byte[] decode(byte[] hexChars) {
        return Hex.decode(hexChars, hexChars.length);
    }

    public static byte[] decode(byte[] hexChars, int length) {
        int size = length / 2;
        byte[] result = new byte[size];
        int idx = 0;
        while (idx < size) {
            int cidx = idx << 1;
            int b = Hex.hexDigit(hexChars[cidx]) << 4 | Hex.hexDigit(hexChars[cidx + 1]);
            result[idx] = (byte)(b & 0xFF);
            ++idx;
        }
        return result;
    }

    public static byte[] readHex(String name, InputStream stream, int size) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[size * 2];
        int remain = buffer.length;
        int totRead = 0;
        while (remain > 0 && (bytesRead = stream.read(buffer, totRead, remain)) > 0) {
            totRead += bytesRead;
            remain -= bytesRead;
        }
        if (totRead != buffer.length) {
            throw new IOException(NLS.bind((String)Messages.unable_to_read_0_hex_chars_from_1, (Object)String.valueOf(buffer.length), (Object)name));
        }
        return Hex.decode(buffer);
    }

    public static void writeHex(byte[] bytes, OutputStream stream) throws IOException {
        int idx = 0;
        while (idx < bytes.length) {
            byte b = bytes[idx];
            int x = (b & 0xF0) >> 4;
            stream.write(x >= 10 ? x + 87 : x + 48);
            x = b & 0xF;
            stream.write(x >= 10 ? x + 87 : x + 48);
            ++idx;
        }
    }

    private static int hexDigit(byte c) {
        int v = 0;
        if (c >= 48 && c <= 57) {
            v = c - 48;
        } else if (c >= 97 && c <= 102) {
            v = c - 97 + 10;
        } else if (c >= 65 && c <= 70) {
            v = c - 65 + 10;
        }
        return v;
    }
}

