/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.fetcher;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.download.Installer;
import org.eclipse.buckminster.fetcher.AbstractResourceFetcher;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchivedResourceFetcher
extends AbstractResourceFetcher {
    private final String filename;
    private final FileFilter filter;
    private final boolean flatten;

    public ArchivedResourceFetcher(URL url, String dir, boolean shouldFlatten, List<String> patternsToInclude) throws CoreException {
        super(url, dir);
        this.filename = url.getFile();
        this.filter = patternsToInclude.isEmpty() ? null : new PatternFileFilter(patternsToInclude);
        this.flatten = shouldFlatten;
    }

    @Override
    protected void consume(InputStream stream, IProgressMonitor monitor) throws IOException, CoreException {
        Installer installer = Installer.getInstaller((String)this.filename, (boolean)true);
        installer.install(stream, new File(this.getDestinationDir()), this.filter, this.flatten, monitor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PatternFileFilter
    implements FileFilter {
        private static final String SEP = System.getProperty("file.separator");
        private List<String> patterns = new ArrayList<String>();

        public PatternFileFilter(Iterable<String> patternsToInclude) {
            for (String p : patternsToInclude) {
                p = p.replace(SEP, "/");
                p = p.replace(".", "\\.");
                p = p.replace("*", ".*");
                p = p.replace("?", ".?");
                this.patterns.add(p);
            }
        }

        @Override
        public boolean accept(File pathname) {
            if (this.patterns.isEmpty()) {
                return true;
            }
            boolean ok = false;
            for (String p : this.patterns) {
                boolean subtract = this.isSubtract(p);
                boolean b = this.match(p = this.rawPatt(p), pathname);
                if (b && subtract) {
                    return false;
                }
                if (!b) continue;
                ok = true;
            }
            return ok;
        }

        private boolean isSubtract(String patt) {
            return patt.startsWith("-");
        }

        private boolean match(String p, File rel) {
            String s = rel.getName();
            if (p.indexOf(47) >= 0) {
                s = rel.toString();
            }
            s = s.replace(SEP, "/");
            return s.matches(p);
        }

        private String rawPatt(String patt) {
            if (!this.isSubtract(patt)) {
                return patt;
            }
            return patt.substring(1);
        }
    }
}

