/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.git.internal;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.buckminster.core.reader.AbstractCatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.git.internal.RepositoryAccess;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TreeEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitReader
extends AbstractCatalogReader {
    private final RepositoryAccess repoAccess;

    protected GitReader(IReaderType readerType, ProviderMatch providerMatch) throws CoreException {
        super(readerType, providerMatch);
        Provider provider = providerMatch.getProvider();
        Map props = provider.getProperties(providerMatch.getNodeQuery().getProperties());
        this.repoAccess = new RepositoryAccess(provider.getURI(props), props);
    }

    public void innerMaterialize(IPath destination, IProgressMonitor monitor) throws CoreException {
        this.repoAccess.checkout(this.getProviderMatch().getVersionMatch(), destination.toFile(), monitor);
    }

    protected boolean innerExists(String fileName, IProgressMonitor monitor) throws CoreException {
        try {
            return this.repoAccess.getComponentTree(this.getProviderMatch().getVersionMatch(), monitor).existsBlob(fileName);
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    protected <T> T innerReadFile(String fileName, IStreamConsumer<T> consumer, IProgressMonitor monitor) throws CoreException, IOException {
        TreeEntry blobEntry = this.repoAccess.getComponentTree(this.getProviderMatch().getVersionMatch(), monitor).findBlobMember(fileName);
        if (blobEntry == null) {
            throw new FileNotFoundException(fileName);
        }
        Repository repo = this.repoAccess.getRepository(monitor);
        ObjectLoader ol = repo.open((AnyObjectId)blobEntry.getId());
        byte[] bytes = ol.getBytes();
        return (T)consumer.consumeStream((IComponentReader)this, fileName, (InputStream)new ByteArrayInputStream(bytes), monitor);
    }
}

