/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.git.internal;

import java.io.File;
import java.net.URI;
import java.util.Date;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.reader.CatalogReaderType;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.IVersionFinder;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.git.internal.GitReader;
import org.eclipse.buckminster.git.internal.VersionFinder;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;

public class GitReaderType
extends CatalogReaderType {
    public URI getArtifactURL(Resolution resolution, RMContext context) throws CoreException {
        return null;
    }

    public IPath getInstallLocation(Resolution resolution, MaterializationContext context) throws CoreException {
        File repo;
        String fmt = resolution.getRepository();
        int comma = fmt.lastIndexOf(44);
        if (comma >= 0) {
            fmt = fmt.substring(0, comma);
            repo = new File(fmt);
        } else {
            repo = new File(fmt).getParentFile();
        }
        return Path.fromOSString((String)repo.getAbsolutePath()).addTrailingSeparator();
    }

    public Date getLastModification(File workingCopy, IProgressMonitor monitor) throws CoreException {
        IPath workingCopyPath;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IContainer resource = wsRoot.getContainerForLocation(workingCopyPath = Path.fromOSString((String)workingCopy.getAbsolutePath()));
        if (resource == null && (resource = wsRoot.getFileForLocation(workingCopyPath)) == null) {
            return null;
        }
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject());
        if (provider == null) {
            return null;
        }
        IFileHistory history = provider.getFileHistoryProvider().getFileHistoryFor((IResource)resource, 1, monitor);
        IFileRevision[] revisions = history.getFileRevisions();
        return revisions.length == 0 ? null : new Date(revisions[0].getTimestamp());
    }

    public IPath getLeafArtifact(Resolution resolution, MaterializationContext context) throws CoreException {
        String fmt = resolution.getRepository();
        int comma = fmt.lastIndexOf(44);
        fmt = comma >= 0 ? fmt.substring(comma + 1) : new File(fmt).getName();
        return Path.fromOSString((String)fmt).addTrailingSeparator();
    }

    public IComponentReader getReader(ProviderMatch providerMatch, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new GitReader((IReaderType)this, providerMatch);
    }

    public IVersionFinder getVersionFinder(Provider provider, IComponentType ctype, NodeQuery nodeQuery, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new VersionFinder(provider, ctype, nodeQuery);
    }

    public void postMaterialization(MaterializationContext context, IProgressMonitor monitor) throws CoreException {
    }

    public void shareProject(IProject project, Resolution cr, RMContext context, IProgressMonitor monitor) throws CoreException {
        ConnectProviderOperation connectOp;
        String fmt = cr.getRepository();
        int comma = fmt.lastIndexOf(44);
        if (comma >= 0) {
            fmt = fmt.substring(0, comma);
            connectOp = new ConnectProviderOperation(project, Path.fromPortableString((String)fmt).append(".git").toFile());
        } else {
            connectOp = new ConnectProviderOperation(project);
        }
        connectOp.execute(monitor);
    }
}

